% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql_node.R
\name{sql_node}
\alias{sql_node}
\title{Make a general SQL node.}
\usage{
sql_node(source, exprs, mods = NULL)
}
\arguments{
\item{source}{source to rename from.}

\item{exprs}{SQL expressions}

\item{mods}{SQL modifiers (GROUP BY, ORDER BY, and so on)}
}
\value{
sql node.
}
\description{
Make a general SQL node.
}
\examples{

my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
d <- dbi_copy_to(my_db, 'd',
                data.frame(AUC = 0.6, R2 = 0.2, z = 3))
eqn <- sql_node(d, "n" := "COUNT(1)")
cat(format(eqn))
sql <- to_sql(eqn, my_db)
cat(sql)
DBI::dbGetQuery(my_db, sql)
DBI::dbDisconnect(my_db)

}
