% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename.R
\name{rename_columns}
\alias{rename_columns}
\title{Make a rename columns node (not a relational operation).}
\usage{
rename_columns(source, cmap)
}
\arguments{
\item{source}{source to rename from.}

\item{cmap}{map written as new column names as keys and old column names as values.}
}
\value{
rename columns node.
}
\description{
Make a rename columns node (not a relational operation).
}
\examples{

if (requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  d <- dbi_copy_to(my_db, 'd',
                   data.frame(AUC = 0.6, R2 = 0.2, z = 3))
  eqn <- rename_columns(d, c('AUC2' := 'AUC', 'R' := 'R2'))
  cat(format(eqn))
  sql <- to_sql(eqn, my_db)
  cat(sql)
  print(DBI::dbGetQuery(my_db, sql))
  DBI::dbDisconnect(my_db)
}

}
