% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordered_select_rows.R
\name{pick_top_k}
\alias{pick_top_k}
\title{Build a optree pipeline that selects up to the top k rows from each group in the given order.}
\usage{
pick_top_k(source, ..., partitionby = NULL, orderby = NULL,
  reverse = NULL, k = 1L, order_expression = "row_number()",
  order_column = "row_number", keep_order_column = TRUE,
  env = parent.frame())
}
\arguments{
\item{source}{relop tree or data.frame source.}

\item{...}{force later arguments to bind by name.}

\item{partitionby}{partitioning (window function) column names.}

\item{orderby}{character, ordering (in window function) column names.}

\item{reverse}{character, reverse ordering (in window function) of these column names.}

\item{k}{integer, number of rows to limit to in each group.}

\item{order_expression}{character, command to compute row-order/rank.}

\item{order_column}{character, column name to write per-group rank in (no ties).}

\item{keep_order_column}{logical, if TRUE retain the order column in the result.}

\item{env}{environment to look for values in.}
}
\description{
This is an example of building up a desired pre-prepared pipleline fragment from relop nodes.
}
\examples{

# by hand logistic regression example
scale <- 0.237
d <- mk_td("survey_table",
           c("subjectID", "surveyCategory", "assessmentTotal"))
optree <- d \%.>\%
  extend_nse(.,
             probability \%:=\%
               exp(assessmentTotal * scale))  \%.>\%
  normalize_cols(.,
                 "probability",
                 partitionby = 'subjectID') \%.>\%
  pick_top_k(.,
             partitionby = 'subjectID',
             orderby = c('probability', 'surveyCategory'),
             reverse = c('probability', 'surveyCategory')) \%.>\%
  rename_columns(., 'diagnosis' \%:=\% 'surveyCategory') \%.>\%
  select_columns(., c('subjectID',
                      'diagnosis',
                      'probability')) \%.>\%
  orderby(., 'subjectID')
cat(format(optree))

}
