% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim_workhorse.R
\name{trim_workhorse}
\alias{trim_workhorse}
\title{TRIM workhorse function}
\usage{
trim_workhorse(count, site, year, month, weights, covars, model,
  changepoints, overdisp, serialcor, autodelete, stepwise,
  covin = list(), constrain_overdisp = 1, conv_crit = 1e-05,
  max_iter = 200, debug = FALSE)
}
\arguments{
\item{count}{a numerical vector of count data.}

\item{site}{a numerical vector time points for each count data point.}

\item{year}{an numerical vector time points for each count data point.}

\item{month}{vector of month data.}

\item{weights}{a numerical vector of weights.}

\item{covars}{an optional data frame with covariates}

\item{model}{a model type selector}

\item{changepoints}{a numerical vector change points (only for Model 2)}

\item{overdisp}{a flag indicating of overdispersion has to be taken into account.}

\item{serialcor}{a flag indication of autocorrelation has to be taken into account.}

\item{covin}{a list of variance-covariance matrices; one per pseudo-site.}

\item{constrain_overdisp}{control constraining overdispersion}

\item{conv_crit}{convergence criterion.}

\item{max_iter}{maximum number of iterations allowed.}

\item{max_beta}{maximum value for beta parameters}
}
\value{
a list of class \code{trim}, that contains all output, statistiscs, etc.
  Usually this information is retrieved by a set of postprocessing functions
}
\description{
TRIM workhorse function
}
\keyword{internal}
