% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{ts_filter}
\alias{ts_filter}
\title{ts_filter}
\usage{
ts_filter(rt, by = "days", dtname = "created_at", txt = "text",
  filter = NULL, key = NULL, na.omit = TRUE, trim = FALSE)
}
\arguments{
\item{rt}{Tweets or users data frame. Technically, this argument
will accept any recursive object (i.e., list or data frame)
containing a named date-time (POSIXt) element or column. By
default, \code{ts_plot} assumes the date-time variable is
labeled "created_at", which is the default date-time label used
in tweets data. However, this function should work with any
data source, assuming it meets the (a) POSIXt class requirement
and (b) the date-time variable is given the appropriate name
(if not "created_at" then a label specified with the
\code{dtname} argument).}

\item{by}{Unit of time, e.g., \code{secs, days, weeks,
months, years} by which to aggregate observations. By default,
\code{ts_plot} tries to aggregate time by "days", but for some
high-frequency data sets that only span a matter of minutes or
hours, this is likely to either produce an error or a truly
disappointing plot. In these cases, users are encouraged to
explore smaller units of time. Conversely, high-frequency and
long [in duration] data sets may be difficult to read given the
default unit of time. In these cases, users should try larger
units of time, e.g., "weeks" or "months". This parameter will
also accept numeric quantifiers in addition to units of time.
By default, for example, the provided unit of time is
assumed to specify whole (1) units of time. It is posible to
tweak this unit by specifying the number (or fraction) of time
units, e.g., \code{by = "2 weeks"}, \code{by = "30 secs"},
\code{by = ".333 days"}.}

\item{dtname}{Name of date-time (POSIXt) column (if data frame)
or element (if list). Defaults to "created_at", the default
label supplied as a timestamp variable for tweets data. This
function is exportable to non-Twitter data, assuming the
intended data object includes a date-time variable with the
same label that's supplied to the \code{dtname} parameter.}

\item{txt}{Name of distinguishing variable in data frame or list
to which filter is applied. Defaults to text.}

\item{filter}{Vector of regular expressions with which to
filter data (creating multiple time series).}

\item{key}{Optional provide pretty labels for filters.
Defaults to actual filters.}

\item{na.omit}{Logical indicating whether to omit rows with
missing (NA) values for the dtname variable. Defaults to TRUE.
If FALSE and data contains missing values for the date-time
variable, an error will be returned to the user.}

\item{trim}{Logical indicating whether to trim extreme intervals,
which often capture artificially lower frequencies. Defaults to
FALSE.}
}
\description{
Converts text-level observations to time aggregated frequency data
  frame with [optional] filtered dummy variable(s).
}

