% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/direct_messages.R
\name{direct_messages_received}
\alias{direct_messages_received}
\title{(DEPRECATED) Get the most recent direct messages sent to the authenticating user.}
\usage{
direct_messages_received(since_id = NULL, max_id = NULL, n = 200,
  parse = TRUE, token = NULL)
}
\arguments{
\item{since_id}{optional Returns results with an ID greater than
(that is, more recent than) the specified ID. There are limits to
the number of Tweets which can be accessed through the API. If
the limit of Tweets has occurred since the since_id, the since_id
will be forced to the oldest ID available.}

\item{max_id}{Character, returns results with an ID less than (that is,
older than) or equal to `max_id`.}

\item{n}{optional Specifies the number of direct messages to try
and retrieve, up to a maximum of 200. The value of count is best
thought of as a limit to the number of Tweets to return because
suspended or deleted content is removed after the count has been
applied.}

\item{parse}{Logical indicating whether to convert response object
into nested list. Defaults to true.}

\item{token}{Every user should have their own Oauth (Twitter API) token. By
default \code{token = NULL} this function looks for the path to a saved
Twitter token via environment variables (which is what `create_token()`
sets up by default during initial token creation). For instruction on how
to create a Twitter token see the tokens vignette, i.e.,
`vignettes("auth", "rtweet")` or see \code{?tokens}.}
}
\value{
Return object converted to nested list. If status code of
  response object is not 200, the response object is returned
  directly.
}
\description{
Retrieves up to 200 of the most recently received direct messages
by the authenticating (home) user. This function requires access
token with read, write, and direct messages access.
}
\details{
Includes detailed information about the sender and
  recipient user. You can request up to 200 direct messages per
  call, and only the most recent 200 direct messages will be available using
  this endpoint.

  Important: This method requires an access token with read,
  write, and direct message permissions. To change your application's
  permissions, navigate to \url{apps.twitter.com}, select the
  appropriate application, click the "permissions" tab. Once you' have made
  changes to the application permission settings, you will need to
  regenerate your token before those effect of those changes can
  take effect.
}
\examples{

\dontrun{

## get my direct messages
dms <- direct_messages_received()

## inspect data structure
str(dms)

## get direct messages I've sent
sdms <- direct_messages_sent()

## inspect data structure
str(dms)

}

}
