% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_color_flat.R
\name{scale_color_flat}
\alias{scale_color_flat}
\alias{scale_color_flat_d}
\alias{scale_color_flat_c}
\alias{scale_colour_flat}
\alias{scale_colour_flat_c}
\alias{scale_colour_flat_d}
\alias{scale_fill_flat}
\alias{scale_fill_flat_d}
\alias{scale_fill_flat_c}
\title{Flat UI color palette}
\usage{
scale_color_flat(palette = "contrast", discrete = TRUE, reverse = FALSE, ...)

scale_color_flat_d(palette = "contrast", discrete = TRUE, reverse = FALSE, ...)

scale_color_flat_c(
  palette = "contrast",
  discrete = FALSE,
  reverse = FALSE,
  ...
)

scale_colour_flat(palette = "contrast", discrete = TRUE, reverse = FALSE, ...)

scale_colour_flat_c(
  palette = "contrast",
  discrete = FALSE,
  reverse = FALSE,
  ...
)

scale_colour_flat_d(
  palette = "contrast",
  discrete = TRUE,
  reverse = FALSE,
  ...
)

scale_fill_flat(palette = "contrast", discrete = TRUE, reverse = FALSE, ...)

scale_fill_flat_d(palette = "contrast", discrete = TRUE, reverse = FALSE, ...)

scale_fill_flat_c(palette = "contrast", discrete = FALSE, reverse = FALSE, ...)
}
\arguments{
\item{palette}{Character name of palette. Depending on the color scale, can be \code{"full"}, \code{"ice"}, \code{"rainbow"}, \code{"complement"}, \code{"contrast"} or \code{"light"} (for dark themes).}

\item{discrete}{Boolean indicating whether color aesthetic is discrete or not.}

\item{reverse}{Boolean indicating whether the palette should be reversed.}

\item{...}{Additional arguments passed to \code{discrete_scale()} or
\code{scale_color_gradientn()}, used respectively when discrete is
\code{TRUE} or \code{FALSE}.}
}
\description{
The palette based on Flat UI (https://www.materialui.co/flatuicolors).
Use \code{scale_color_flat_d} for \emph{discrete} categories and
\code{scale_color_flat_c} for a \emph{continuous} scale.
}
\examples{
library(ggplot2)
library(see)

ggplot(iris, aes(x = Species, y = Sepal.Length, fill = Species)) +
  geom_boxplot() +
  theme_modern() +
  scale_fill_flat_d()

ggplot(iris, aes(x = Species, y = Sepal.Length, fill = Species)) +
  geom_violin() +
  theme_modern() +
  scale_fill_flat_d(palette = "ice")

ggplot(iris, aes(x = Petal.Length, y = Petal.Width, color = Sepal.Length)) +
  geom_point() +
  theme_modern() +
  scale_color_flat_c(palette = "rainbow")
}
