% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SUVR.R
\name{suvr}
\alias{suvr}
\title{Calculate weighted SUVRs for specified regions of interest}
\usage{
suvr(tac, SUVR_def, ref, ...)
}
\arguments{
\item{tac}{The time-activity curve data from tac_roi()}

\item{SUVR_def}{a vector of start times for window to be used in SUVR}

\item{ref}{a string, e.g. "cerebellum", to specify reference region}

\item{...}{When called from tm_batch, unused parameters may be supplied}
}
\value{
A data.frame of SUVR values for the specified ROIs
}
\description{
Calculate the standardized uptake value ratio (SUVR) for all ROIs in the
provided tac data, using the specified reference region.
}
\examples{
f <- system.file("extdata", "AD06.tac", package="tacmagic")
fv <- system.file("extdata", "AD06_TAC.voistat", package="tacmagic")
AD06_tac <- load_tac(f, format="PMOD")
AD06_volume <- load_vol(fv, format="voistat")
AD06 <- tac_roi(tac=AD06_tac, volumes=AD06_volume, ROI_def=roi_ham_pib(),  
                merge=FALSE, PVC=FALSE)

AD06_SUVR <- suvr(AD06, SUVR_def=c(3000,3300,3600), ref="cerebellum")

}
\seealso{
Other SUVR functions: \code{\link{suvr_auc}}
}
\concept{SUVR functions}
