% Generated by roxygen2 (4.0.0): do not edit by hand
\name{get_tsn}
\alias{get_tsn}
\title{Get the TSN code for a search term.}
\usage{
get_tsn(searchterm, searchtype = "scientific", accepted = TRUE,
  ask = TRUE, verbose = TRUE)
}
\arguments{
\item{searchterm}{character; A vector of common or scientific names.}

\item{searchtype}{character; One of 'scientific' or 'common', or any unique abbreviation}

\item{accepted}{logical; If TRUE (default), removes names that are not accepted valid names
by ITIS. Set to FALSE to give back both accepted and unaccepted names.}

\item{ask}{logical; should get_tsn be run in interactive mode?
If TRUE and more than one TSN is found for teh species, the user is asked for
input. If FALSE NA is returned for multiple matches.}

\item{verbose}{logical; should progress be printed?}
}
\value{
A vector of taxonomic serial numbers (TSN). If a taxon is not
   found NA. If more than one TSN is found the function asks for user input
   (if ask = TRUE), otherwise returns NA.
   Comes with an attribute \emph{match} to investigate the reason for NA (either 'not found',
     'found' or if ask = FALSE 'multi match')
}
\description{
Retrieve the taxonomic serial numbers (TSN) of a taxon from ITIS.
}
\examples{
\dontrun{
get_tsn(searchterm = "Quercus douglasii")
get_tsn(searchterm = "Chironomus riparius")
get_tsn(c("Chironomus riparius","Quercus douglasii"))
splist <- c("annona cherimola", 'annona muricata', "quercus robur",
		"shorea robusta", "pandanus patina", "oryza sativa", "durio zibethinus")
get_tsn(splist, verbose=FALSE)

# When not found
get_tsn("howdy")
get_tsn(c("Chironomus riparius", "howdy"))

# Using common names
get_tsn(searchterm="black bear", searchtype="c")
}
}
\seealso{
\code{\link[taxize]{get_uid}}, \code{\link[taxize]{classification}}
}

