% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{package}
\name{taxize-package}
\alias{taxize}
\alias{taxize-package}
\title{Taxonomic information from around the web.}
\description{
Taxnomic search and phylogeny retrieval.
}
\details{
We are developing taxize as a package to allow users to search over many
websites for species names (scientific and common) and download up- and
downstream taxonomic hierarchical information - and many other things.

The functions in the package that hit a specific API have a prefix and suffix
separated by an underscore. They follow the format of \code{service_whatitdoes}.
For example, \code{gnr_resolve} uses the Global Names Resolver API to resolve
species names.

General functions in the package that don't hit a specific API don't have
two words separated by an underscore, e.g., \code{classification}

You need API keys for Encyclopedia of Life (EOL), the Universal Biological
Indexer and Organizer (uBio), Tropicos, and Plantminer.

Currently supported APIs are:

\tabular{llc}{
API \tab prefix \tab SOAP? \cr
Encyclopedia of Life (EOL)  \tab eol \tab FALSE \cr
Integrated Taxonomic Information Service (ITIS)  \tab itis \tab FALSE \cr
Phylomatic \tab phylomatic \tab FALSE \cr
uBio \tab ubio \tab FALSE \cr
Global Names Resolver (from EOL/GBIF) \tab gnr \tab FALSE \cr
Global Names Index (from EOL/GBIF) \tab gni \tab FALSE \cr
IUCN Red List \tab iucn \tab FALSE \cr
Tropicos (from Missouri Botanical Garden) \tab tp \tab FALSE \cr
Plantminer \tab plantminer \tab FALSE \cr
Theplantlist.org \tab tpl \tab FALSE \cr
Catalogue of Life \tab col \tab FALSE \cr
Global Invasive Species Database \tab gisd \tab FALSE \cr
National Center for Biotechnology Information \tab ncbi \tab FALSE \cr
CANADENSYS Vascan name search API \tab vascan \tab FALSE \cr
International Plant Names Index (IPNI) \tab ipni \tab FALSE \cr
World Register of Marine Species (WoRMS) \tab worms \tab TRUE \cr
Barcode of Life Data Systems (BOLD) \tab bold \tab FALSE \cr
Pan-European Species directories Infrastructure (PESI) \tab pesi \tab TRUE \cr
Mycobank \tab myco \tab TRUE \cr
}

If the source above has a \code{TRUE} in the \code{SOAP?} column, it is not available if you
installed this package from CRAN. See the Github repo for how to install the version with the
data sources that use SOAP web services:
\url{https://github.com/ropensci/taxize#version-with-soap-data-sources}
}
\author{
Scott Chamberlain \email{myrmecocystus@gmail.com}

Eduard Szoecs \email{eduardszoecs@gmail.com}

Carl Boettiger \email{cboettig@gmail.com}

Karthik Ram \email{karthik@ropensci.org}

Ignasi Bartomeus \email{nacho.bartomeus@gmail.com}

John Baumgartner \email{johnbb@student.unimelb.edu.au}
}
\keyword{package}

