% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/get_tsn.R
\name{get_tsn}
\alias{as.data.frame.tsn}
\alias{as.tsn}
\alias{as.tsn.character}
\alias{as.tsn.data.frame}
\alias{as.tsn.list}
\alias{as.tsn.numeric}
\alias{as.tsn.tsn}
\alias{get_tsn}
\alias{get_tsn_}
\title{Get the TSN code for a search term.}
\usage{
get_tsn(searchterm, searchtype = "scientific", accepted = TRUE,
  ask = TRUE, verbose = TRUE, rows = NA, ...)

as.tsn(x, check = TRUE)

\method{as.tsn}{tsn}(x, check = TRUE)

\method{as.tsn}{character}(x, check = TRUE)

\method{as.tsn}{list}(x, check = TRUE)

\method{as.tsn}{numeric}(x, check = TRUE)

\method{as.tsn}{data.frame}(x, check = TRUE)

\method{as.data.frame}{tsn}(x, ...)

get_tsn_(searchterm, verbose = TRUE, searchtype = "scientific",
  accepted = TRUE, rows = NA)
}
\arguments{
\item{searchterm}{character; A vector of common or scientific names.}

\item{searchtype}{character; One of 'scientific' or 'common', or any unique abbreviation}

\item{accepted}{logical; If TRUE (default), removes names that are not accepted valid names
by ITIS. Set to FALSE to give back both accepted and unaccepted names.}

\item{ask}{logical; should get_tsn be run in interactive mode?
If TRUE and more than one TSN is found for teh species, the user is asked for
input. If FALSE NA is returned for multiple matches.}

\item{verbose}{logical; should progress be printed?}

\item{rows}{numeric; Any number from 1 to inifity. If the default NA, all rows are considered.
Note that this function still only gives back a tsn class object with one to many identifiers.
See \code{\link[taxize]{get_tsn_}} to get back all, or a subset, of the raw data that you are
presented during the ask process.}

\item{...}{Ignored}

\item{x}{Input to as.tsn}

\item{check}{logical; Check if ID matches any existing on the DB, only used in
\code{\link{as.tsn}}}
}
\value{
A vector of taxonomic serial numbers (TSN). If a taxon is not
   found NA. If more than one TSN is found the function asks for user input
   (if ask = TRUE), otherwise returns NA.
   Comes with an attribute \emph{match} to investigate the reason for NA (either 'not found',
     'found' or if ask = FALSE 'multi match')
}
\description{
Retrieve the taxonomic serial numbers (TSN) of a taxon from ITIS.
}
\examples{
\dontrun{
get_tsn(searchterm = "Quercus douglasii")
get_tsn(searchterm = "Chironomus riparius")
get_tsn(c("Chironomus riparius","Quercus douglasii"))
splist <- c("annona cherimola", 'annona muricata', "quercus robur",
		"shorea robusta", "pandanus patina", "oryza sativa", "durio zibethinus")
get_tsn(splist, verbose=FALSE)

# specify rows to limit choices available
get_tsn('Poa annua')
get_tsn('Poa annua', rows=1)
get_tsn('Poa annua', rows=25)
get_tsn('Poa annua', rows=1:2)

# When not found
get_tsn("howdy")
get_tsn(c("Chironomus riparius", "howdy"))

# Using common names
get_tsn(searchterm="black bear", searchtype="c")

# Convert a tsn without class information to a tsn class
as.tsn(get_tsn("Quercus douglasii")) # already a tsn, returns the same
as.tsn(get_tsn(c("Chironomus riparius","Pinus contorta"))) # same
as.tsn(19322) # numeric
as.tsn(c(19322,129313,506198)) # numeric vector, length > 1
as.tsn("19322") # character
as.tsn(c("19322","129313","506198")) # character vector, length > 1
as.tsn(list("19322","129313","506198")) # list, either numeric or character
## dont check, much faster
as.tsn("19322", check=FALSE)
as.tsn(19322, check=FALSE)
as.tsn(c("19322","129313","506198"), check=FALSE)
as.tsn(list("19322","129313","506198"), check=FALSE)

(out <- as.tsn(c(19322,129313,506198)))
data.frame(out)
as.tsn( data.frame(out) )

# Get all data back
get_tsn_("Poa annua")
get_tsn_("Poa annua", rows=1)
get_tsn_("Poa annua", rows=1:2)
get_tsn_(c("asdfadfasd","Pinus contorta"), rows=1:5)
}
}
\seealso{
\code{\link[taxize]{classification}}
}

