% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eubon_children.R
\name{eubon_children}
\alias{eubon_children}
\title{EUBON children}
\usage{
eubon_children(id, providers = NULL, timeout = 0, ...)
}
\arguments{
\item{id}{(character) identifier for the taxon. (LSID, DOI, URI, or any
other identifier used by the checklist provider)}

\item{providers}{(character) A list of provider id strings concatenated by
comma characters. The default : "pesi,bgbm-cdm-server[col]" will be used if
this parameter is not set. A list of all available provider ids can be
obtained from the '/capabilities' service end point. Providers can be
nested, that is a parent provider can have sub providers. If the id of the
parent provider is supplied all subproviders will be queried. The query
can also be restriced to one or more subproviders by using the following
syntax: parent-id[sub-id-1,sub-id2,...]}

\item{timeout}{(numeric) The maximum of milliseconds to wait for responses
from any of the providers. If the timeout is exceeded the service will just
return the resonses that have been received so far. The default timeout is
0 ms (wait for ever)}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
a data.frame or an empty list if no results found
}
\description{
EUBON children
}
\examples{
\dontrun{
x <- eubon_children(id = "urn:lsid:marinespecies.org:taxname:126141",
  providers = 'worms')
head(x)
}
}
\references{
\url{http://cybertaxonomy.eu/eu-bon/utis/1.2/doc.html}
}
\seealso{
Other eubon-methods: \code{\link{eubon_capabilities}},
  \code{\link{eubon_hierarchy}}, \code{\link{eubon}}
}

