% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_iucn.R
\name{get_iucn}
\alias{get_iucn}
\alias{as.iucn}
\alias{as.iucn.iucn}
\alias{as.iucn.character}
\alias{as.iucn.list}
\alias{as.iucn.numeric}
\alias{as.iucn.data.frame}
\alias{as.data.frame.iucn}
\title{Get a IUCN Redlist taxon}
\usage{
get_iucn(x, verbose = TRUE, key = NULL, ...)

as.iucn(x, check = TRUE, key = NULL)

\method{as.iucn}{iucn}(x, check = TRUE, key = NULL)

\method{as.iucn}{character}(x, check = TRUE, key = NULL)

\method{as.iucn}{list}(x, check = TRUE, key = NULL)

\method{as.iucn}{numeric}(x, check = TRUE, key = NULL)

\method{as.iucn}{data.frame}(x, check = TRUE, key = NULL)

\method{as.data.frame}{iucn}(x, ...)
}
\arguments{
\item{x}{(character) A vector of common or scientific names}

\item{verbose}{logical; should progress be printed?}

\item{key}{(character) you IUCN Redlist API key. See
\code{\link[rredlist]{rredlist-package}} for help on authenticating with
IUCN Redlist}

\item{...}{Ignored}

\item{check}{(logical) Check if ID matches any existing on the DB, only
used in \code{\link{as.iucn}}}
}
\value{
A vector of taxonomic identifiers as an S3 class.

Comes with the following attributes:
\itemize{
 \item \emph{match} (character) - the reason for NA, either 'not found',
 'found' or if \code{ask = FALSE} then 'NA due to ask=FALSE')
 \item \emph{name} (character) - the taxonomic name, which is needed in
 \code{\link{synonyms}} and \code{\link{sci2comm}} methods since they
 internally use \pkg{rredlist} functions which require the taxonomic name,
 and not the taxonomic identifier
 \item \emph{uri} (character) - The URI where more information can be
 read on the taxon - includes the taxonomic identifier in the URL somewhere
}

\emph{multiple_matches} and \emph{pattern_match} do not apply here as in
other \code{get_*} methods since there is no IUCN Redlist search,
so you either get a match or you do not get a match.
}
\description{
Get a IUCN Redlist taxon
}
\details{
There is no underscore method, because there's no real
search for IUCN, that is, where you search for a string, and get back
a bunch of results due to fuzzy matching. If that exists in the future
we'll add an underscore method here.

IUCN ids only work with \code{\link{synonyms}} and \code{\link{sci2comm}}
methods.
}
\examples{
\dontrun{
get_iucn(x = "Branta canadensis")
get_iucn(x = "Branta bernicla")
get_iucn(x = "Panthera uncia")

# as coercion
as.iucn(22732)
as.iucn("22732")
(res <- as.iucn(c(22679946, 22732, 22679935)))
data.frame(res)
as.iucn(data.frame(res))
}
}
\seealso{
Other taxonomic-ids: \code{\link{get_boldid}},
  \code{\link{get_colid}}, \code{\link{get_eolid}},
  \code{\link{get_gbifid}}, \code{\link{get_ids}},
  \code{\link{get_natservid}}, \code{\link{get_nbnid}},
  \code{\link{get_tolid}}, \code{\link{get_tpsid}},
  \code{\link{get_tsn}}, \code{\link{get_uid}},
  \code{\link{get_wiki}}, \code{\link{get_wormsid}}
}
