% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sci2comm.R
\name{sci2comm}
\alias{sci2comm}
\alias{sci2comm.default}
\alias{sci2comm.uid}
\alias{sci2comm.tsn}
\alias{sci2comm.wormsid}
\alias{sci2comm.iucn}
\title{Get common names from scientific names.}
\usage{
sci2comm(...)

\method{sci2comm}{default}(scinames, db = "eol", simplify = TRUE, ...)

\method{sci2comm}{uid}(id, ...)

\method{sci2comm}{tsn}(id, simplify = TRUE, ...)

\method{sci2comm}{wormsid}(id, simplify = TRUE, ...)

\method{sci2comm}{iucn}(id, simplify = TRUE, ...)
}
\arguments{
\item{...}{Further arguments passed on to functions
\code{\link[taxize]{get_uid}}, \code{\link[taxize]{get_tsn}}.}

\item{scinames}{character; One or more scientific names or partial names.}

\item{db}{character; Data source, one of \emph{"eol"} (default),
\emph{"itis"} \emph{"ncbi"}, \emph{"worms"}, or \emph{"iucn"}. Note that
each taxonomic data source has their own identifiers,  so that if you
provide the wrong \code{db} value for the identifier you could get a
result, but it will likely be wrong (not what you were expecting).}

\item{simplify}{(logical) If TRUE, simplify output to a vector of names.
If FALSE, return variable formats from different sources, usually a
data.frame. Only applies to eol and itis. Specify \code{FALSE} to obtain
the language of each vernacular in the output for eol and itis.}

\item{id}{character; identifiers, as returned by
\code{\link[taxize]{get_tsn}}, \code{\link[taxize]{get_uid}}.}
}
\value{
List of character vectors, named by input taxon name, or taxon ID
}
\description{
Get common names from scientific names.
}
\section{Authentication}{

See \code{\link{taxize-authentication}} for help on authentication
}

\examples{
\dontrun{
sci2comm(scinames='Helianthus annuus', db='eol')
sci2comm(scinames='Helianthus annuus', db='itis')
sci2comm(scinames=c('Helianthus annuus', 'Poa annua'))
sci2comm(scinames='Puma concolor', db='ncbi')
sci2comm('Gadus morhua', db='worms')
sci2comm('Pomatomus saltatrix', db='worms')
sci2comm('Loxodonta africana', db='iucn')

# Passing id in, works for sources: itis and ncbi, not eol
sci2comm(get_tsn('Helianthus annuus'))
sci2comm(get_uid('Helianthus annuus'))
sci2comm(get_wormsid('Gadus morhua'))
sci2comm(get_iucn('Loxodonta africana'))

# Don't simplify returned
sci2comm(get_tsn('Helianthus annuus'), simplify=FALSE)
sci2comm(get_iucn('Loxodonta africana'), simplify=FALSE)

# Use curl options
sci2comm('Helianthus annuus', db="ncbi", verbose = TRUE)
}
}
\seealso{
\code{\link[taxize]{comm2sci}}
}
\author{
Scott Chamberlain (myrmecocystus@gmail.com)
}
