% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key_helpers.R
\name{key_helpers}
\alias{key_helpers}
\alias{use_tropicos}
\alias{use_eol}
\alias{use_entrez}
\alias{use_iucn}
\title{Helpers to set up authentication for the different providers.}
\usage{
use_tropicos()

use_eol()

use_entrez()

use_iucn()
}
\description{
Sets up authentication to diverse providers by providing the user a detailed prompt.
}
\details{
Key helpers

This function only wraps \code{\link[rredlist]{rl_use_iucn}}
 from the \code{rredlist} package.
 After filling the form you will get the key shortly
 but not immediately.
}
\section{`use_tropicos()`}{

Browse Tropicos API key request URL and
 provides instruction on how to store the key.
 @details After filling the form you will get the key shortly
  but not immediately.
}

\section{`use_eol()`}{

Browse EOL to help make an API key request and
 provides instruction on how to store the key.
There's no direct URL to request a key, one first needs 
to log in or register and then to generate a key from one's Preferences
page.
}

\section{`use_entrez()`}{

Browse NCBI Entrez to help make an API key request and
 provides instruction on how to store the key.
There's no direct URL to request a key, one first needs 
to log in or register and then to generate a key from one's account.

Note that NCBI Entrez doesn't require that you use an API key, 
but you should get higher rate limit with a key, so do get one.
}

\section{`use_iucn()`}{

Browse IUCN Red List API key request URL and
 provides instruction on how to store the key.
}

