% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbn_search.R
\name{nbn_search}
\alias{nbn_search}
\title{Search UK National Biodiversity Network}
\usage{
nbn_search(q, fq = NULL, order = NULL, sort = NULL, start = 0,
  rows = 25, facets = NULL, ...)
}
\arguments{
\item{q}{(character) The query terms(s)}

\item{fq}{(character) Filters to be applied to the original query. These
are additional params of the form fq=INDEXEDFIELD:VALUE e.g.
fq=rank:kingdom. See \url{https://species-ws.nbnatlas.org/indexFields} for all
the fields that are queryable.}

\item{order}{(character) Supports "asc" or "desc"}

\item{sort}{(character) The indexed field to sort by}

\item{start}{(integer) Record offset, to enable paging}

\item{rows}{(integer) Number of records to return}

\item{facets}{(list) Comma separated list of the fields to create facets
on e.g. facets=basis_of_record.}

\item{...}{Further args passed on to \link[crul:HttpClient]{crul::HttpClient}.}
}
\value{
a list with slots for metadata (\code{meta}) with list of response
attributes, and data (\code{data}) with a data.frame of results
}
\description{
Search UK National Biodiversity Network
}
\examples{
\dontrun{
x <- nbn_search(q = "Vulpes")
x$meta$totalRecords
x$meta$pageSize
x$meta$urlParameters
x$meta$queryTitle
head(x$data)

nbn_search(q = "blackbird", start = 4)

# debug curl stuff
nbn_search(q = "blackbird", verbose = TRUE)
}
}
\references{
\url{https://api.nbnatlas.org/}
}
\seealso{
Other nbn: \code{\link{get_nbnid}},
  \code{\link{nbn_classification}},
  \code{\link{nbn_synonyms}}
}
\author{
Scott Chamberlain, \email{myrmecocystus@gmail.com}
}
\concept{nbn}
