% Generated by roxygen2 (4.0.2): do not edit by hand
\name{mink.dists}
\alias{mink.dists}
\title{Minkowski distances from a Spatial* or Spatial*DataFrame object}
\usage{
mink.dists(swdf1, swdf2, pwr, scale, weight)
}
\arguments{
\item{swdf1}{- First Spatial*DataFrame object}

\item{swdf2}{- Second Spatial*DataFrame object (if omitted,  defaults to the same value as \code{swdf1})}

\item{pwr}{- Minkowski exponent}

\item{scale}{- allows re-scaling eg: value of 1000 means distances in km if coordinates of \code{swdf1}/\code{swdf2} in meters.}

\item{weight}{- weight for each element in swdf1 (the demand locations)}
}
\value{
Distance matrix (if \code{swdf1} or \code{swdf2} not SpatialPoints*,
  distances are based on points obtained from \code{coordinates} function)
}
\description{
Minkowski distances from a Spatial* or Spatial*DataFrame object
}
\examples{
data(meuse)
coordinates(meuse) <- ~x+y
d1 <- mink.dists(meuse,pwr=1,scale=1000)   # Taxicab metric
d2 <- mink.dists(meuse,pwr=Inf,scale=1000) # Works for limiting case
}

