% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.miniseq.specifications.R
\name{prepare.miniseq.specifications}
\alias{prepare.miniseq.specifications}
\title{prepare.miniseq.specifications}
\usage{
prepare.miniseq.specifications(sample.sheet, miniseq.directory)
}
\arguments{
\item{sample.sheet}{Data frame containing sample information, or path to a MiniSeq sample sheet}

\item{miniseq.directory}{Path to directory with MiniSeq files}
}
\value{
A list with specification data frames 'fastq', 'bam', and 'vcf' (as applicable)
}
\description{
Process a MiniSeq directory and sample sheet to get specification data frames
that can be used to run the VariTAS pipeline.

	Note: This assumes normal samples are not available.
}
\examples{
miniseq.sheet <- file.path(path.package('varitas'), 'extdata/miniseq/Example_template.csv')
miniseq.directory <- file.path(path.package('varitas'), 'extdata/miniseq')
miniseq.info <- prepare.miniseq.specifications(miniseq.sheet, miniseq.directory)


}
