% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictiveness_se.R
\name{predictiveness_se}
\alias{predictiveness_se}
\title{Estimate standard errors for measures of predictiveness}
\usage{
predictiveness_se(est, update, denom = NULL, n = length(update), na.rm = FALSE)
}
\arguments{
\item{est}{the estimate of variable importance.}

\item{update}{the influence curve-based update.}

\item{denom}{a list of point estimate and influence curve for the denominator (if any) to make the measure of predictiveness interpretable.}

\item{n}{the sample size.}

\item{na.rm}{logical; should NA's be removed in computation? (defaults to \code{FALSE}).}
}
\value{
The standard error for the estimated measure of predictiveness for the given group of covariates.
}
\description{
Compute standard error estimates for estimates of measures of predictiveness.
}
\details{
See the paper by Williamson, Gilbert, Simon, and Carone for more
details on the mathematics behind this function and the definition of the parameter of interest.
}
