% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glob_knn_vis.R
\name{glob_knn_vis}
\alias{glob_knn_vis}
\title{Global Visualization of SHAP Values for K-Nearest Neighbor Model}
\usage{
glob_knn_vis(vip_featured, hiv_data, knn_hyperparameters, vip_train, v_train)
}
\arguments{
\item{vip_featured}{The name of the response variable to explain.}

\item{hiv_data}{The training dataset containing predictor variables and the response variable.}

\item{knn_hyperparameters}{A list of hyperparameters for the KNN model, including:
\itemize{
\item \code{neighbors}: The number of neighbors to consider.
\item \code{weight_func}: The weight function to use.
\item \code{dist_power}: The distance power parameter.
}}

\item{vip_train}{The dataset used for training the KNN model.}

\item{v_train}{The response variable used for training the KNN model.}
}
\value{
A visualization of global feature importance for the KNN model.
}
\description{
This function generates a visualization for the global feature importance of
a K-Nearest Neighbors (KNN) model trained on HIV data with specified
hyperparameters.
}
\examples{
library(dplyr)
set.seed(123)
hiv_data <- train2
knn_hyperparameters <- list(neighbors = 5, weight_func = "optimal", dist_power = 0.3304783)
vip_featured <- c("cd_2022")
vip_features <- c("cd_2019", "vl_2019", "cd_2021", "vl_2021", "vl_2022")
vip_train <- train2 |>
dplyr::select(rsample::all_of(vip_features))
v_train <- train2 |>
dplyr::select(rsample::all_of(vip_featured))
glob_knn_vis(vip_featured, hiv_data, knn_hyperparameters, vip_train, v_train)
}
