% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runiverse-packages.R
\name{wood_runiverse_packages}
\alias{wood_runiverse_packages}
\title{List available packages in one of R universes}
\usage{
wood_runiverse_packages(universe = "ropensci")
}
\arguments{
\item{universe}{\code{character(1)}\cr
Name of a universe within R-universe, e.g. "ropensci".}
}
\value{
A character vector of available packages.
}
\description{
This function queries the selected universe for a list of
available packages. They are returned as a vector of strings, each element
being a package name.
}
\examples{
\donttest{
wood_runiverse_packages()
wood_runiverse_packages("tidyverse")
}

}
\seealso{
Functions for R-universe:
\code{\link{wood_runiverse_dependencies}()},
\code{\link{wood_runiverse_version}()}

Functions that query available packages:
\code{\link{wood_bioc_packages}()},
\code{\link{wood_core_packages}()},
\code{\link{wood_cran_packages}()},
\code{\link{wood_github_packages}()},
\code{\link{wood_local_packages}()},
\code{\link{wood_packages}()},
\code{\link{wood_url_packages}()}
}
\concept{packages}
\concept{runiverse}
