library(xpectr)
context("gxs_selection()")

test_that("data frame expectations are created properly with gxs_selection()", {

  set_test_seed(1)
  df1 <- tibble::tibble("a" = c(1, 2, 3, 4), "b" = c("a", "f", "g", "s"))

  ## Testing 'gxs_selection("df1", out = "return")'                         ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_12655 <- gxs_selection("df1", out = "return")
  # Testing class
  expect_equal(
    class(output_12655),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12655,
    type = "list")
  # Testing values
  expect_equal(
    output_12655,
    list(
      " ",
      "## Testing 'df1'                                                            ####",
      "## Initially generated by xpectr",
      "xpectr::set_test_seed(42)",
      "# Testing class",
      "expect_equal(\n  class(df1),\n  c(\"tbl_df\", \"tbl\", \"data.frame\"),\n  fixed = TRUE)",
      "# Testing column values",
      "expect_equal(\n  df1[[\"a\"]],\n  c(1, 2, 3, 4),\n  tolerance = 1e-4)",
      "expect_equal(\n  df1[[\"b\"]],\n  c(\"a\", \"f\", \"g\", \"s\"),\n  fixed = TRUE)",
      "# Testing column names",
      "expect_equal(\n  names(df1),\n  c(\"a\", \"b\"),\n  fixed = TRUE)",
      "# Testing column classes",
      "expect_equal(\n  xpectr::element_classes(df1),\n  c(\"numeric\", \"character\"),\n  fixed = TRUE)",
      "# Testing column types",
      "expect_equal(\n  xpectr::element_types(df1),\n  c(\"double\", \"character\"),\n  fixed = TRUE)",
      "# Testing dimensions",
      "expect_equal(\n  dim(df1),\n  c(4L, 2L))",
      "# Testing group keys",
      "expect_equal(\n  colnames(dplyr::group_keys(df1)),\n  character(0),\n  fixed = TRUE)",
      "## Finished testing 'df1'                                                   ####",
      " "
    ))
  # Testing names
  expect_equal(
    names(output_12655),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12655),
    21L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12655)),
    21L)
  ## Finished testing 'gxs_selection("df1", out = "return")'                ####

  set_test_seed(10)
  ## Testing 'gxs_selection("tibble::tibble('a' = c(1, 2, ...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_15074 <- gxs_selection("tibble::tibble('a' = c(1, 2, 3, 4), 'b' = c('b', 'f', 'g', 's'))", out = "return")
  # Testing class
  expect_equal(
    class(output_15074),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_15074,
    type = "list")
  # Testing values
  expect_equal(
    output_15074,
    list(" ",
         "## Testing 'tibble::tibble('a' = c(1, 2, 3, 4), 'b' = c('b...'              ####",
         "## Initially generated by xpectr",
         "xpectr::set_test_seed(42)", "# Assigning output", "output_19148 <- tibble::tibble('a' = c(1, 2, 3, 4), 'b' = c('b', 'f', 'g', 's'))",
         "# Testing class", "expect_equal(\n  class(output_19148),\n  c(\"tbl_df\", \"tbl\", \"data.frame\"),\n  fixed = TRUE)",
         "# Testing column values", "expect_equal(\n  output_19148[[\"a\"]],\n  c(1, 2, 3, 4),\n  tolerance = 1e-4)",
         "expect_equal(\n  output_19148[[\"b\"]],\n  c(\"b\", \"f\", \"g\", \"s\"),\n  fixed = TRUE)",
         "# Testing column names", "expect_equal(\n  names(output_19148),\n  c(\"a\", \"b\"),\n  fixed = TRUE)",
         "# Testing column classes", "expect_equal(\n  xpectr::element_classes(output_19148),\n  c(\"numeric\", \"character\"),\n  fixed = TRUE)",
         "# Testing column types", "expect_equal(\n  xpectr::element_types(output_19148),\n  c(\"double\", \"character\"),\n  fixed = TRUE)",
         "# Testing dimensions", "expect_equal(\n  dim(output_19148),\n  c(4L, 2L))",
         "# Testing group keys", "expect_equal(\n  colnames(dplyr::group_keys(output_19148)),\n  character(0),\n  fixed = TRUE)",
         "## Finished testing 'tibble::tibble('a' = c(1, 2, 3, 4), 'b' = c('b...'     ####",
         " "))
  # Testing names
  expect_equal(
    names(output_15074),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_15074),
    23L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_15074)),
    23L)
  ## Finished testing 'gxs_selection("tibble::tibble('a' = c(1, 2, ...'     ####

  df1$c <- list(list(1, 2, 3), list(2, 3, 4, 5), list(2, 3, 7, 21, 2), list(2))

  set_test_seed(1)
  ## Testing 'gxs_selection("df1", out = "return")'                         ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12655 <- xpectr::capture_side_effects(gxs_selection("df1", out = "return"))
  expect_equal(
    xpectr::strip(side_effects_12655[['warnings']]),
    xpectr::strip("Skipped column c."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12655[['messages']]),
    xpectr::strip(character(0)),
    fixed = TRUE)
  # Assigning output
  output_12655 <- xpectr::suppress_mw(gxs_selection("df1", out = "return"))
  # Testing class
  expect_equal(
    class(output_12655),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12655,
    type = "list")
  # Testing values
  expect_equal(
    output_12655,
    list(" ",
         "## Testing 'df1'                                                            ####",
         "## Initially generated by xpectr",
         "xpectr::set_test_seed(42)", "# Testing class", "expect_equal(\n  class(df1),\n  c(\"tbl_df\", \"tbl\", \"data.frame\"),\n  fixed = TRUE)",
         "# Testing column values", "expect_equal(\n  df1[[\"a\"]],\n  c(1, 2, 3, 4),\n  tolerance = 1e-4)",
         "expect_equal(\n  df1[[\"b\"]],\n  c(\"a\", \"f\", \"g\", \"s\"),\n  fixed = TRUE)",
         "# Testing column names", "expect_equal(\n  names(df1),\n  c(\"a\", \"b\", \"c\"),\n  fixed = TRUE)",
         "# Testing column classes", "expect_equal(\n  xpectr::element_classes(df1),\n  c(\"numeric\", \"character\", \"list\"),\n  fixed = TRUE)",
         "# Testing column types", "expect_equal(\n  xpectr::element_types(df1),\n  c(\"double\", \"character\", \"list\"),\n  fixed = TRUE)",
         "# Testing dimensions", "expect_equal(\n  dim(df1),\n  4:3)",
         "# Testing group keys", "expect_equal(\n  colnames(dplyr::group_keys(df1)),\n  character(0),\n  fixed = TRUE)",
         "## Finished testing 'df1'                                                   ####",
         " "))
  # Testing names
  expect_equal(
    names(output_12655),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12655),
    21L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12655)),
    21L)
  ## Finished testing 'gxs_selection("df1", out = "return")'                ####


})

test_that("data.table expectations are created properly with gxs_selection()", {

  suppress_mw(library(data.table))
  set_test_seed(1)
  df1 <- data.table("a" = c(1, 2, 3, 4), "b" = c("a", "f", "g", "s"))

  ## Testing 'gxs_selection("df1", out = "return")'                         ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_12655 <- gxs_selection("df1", out = "return")
  # Testing class
  expect_equal(
    class(output_12655),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12655,
    type = "list")
  # Testing values
  expect_equal(
    output_12655,
    list(
      " ",
      "## Testing 'df1'                                                            ####",
      "## Initially generated by xpectr",
      "xpectr::set_test_seed(42)",
      "# Testing class",
      "expect_equal(\n  class(df1),\n  c(\"data.table\", \"data.frame\"),\n  fixed = TRUE)",
      "# Testing column values",
      "expect_equal(\n  df1[[\"a\"]],\n  c(1, 2, 3, 4),\n  tolerance = 1e-4)",
      "expect_equal(\n  df1[[\"b\"]],\n  c(\"a\", \"f\", \"g\", \"s\"),\n  fixed = TRUE)",
      "# Testing column names",
      "expect_equal(\n  names(df1),\n  c(\"a\", \"b\"),\n  fixed = TRUE)",
      "# Testing column classes",
      "expect_equal(\n  xpectr::element_classes(df1),\n  c(\"numeric\", \"character\"),\n  fixed = TRUE)",
      "# Testing column types",
      "expect_equal(\n  xpectr::element_types(df1),\n  c(\"double\", \"character\"),\n  fixed = TRUE)",
      "# Testing dimensions",
      "expect_equal(\n  dim(df1),\n  c(4L, 2L))",
      "# Testing group keys",
      "expect_equal(\n  colnames(dplyr::group_keys(df1)),\n  character(0),\n  fixed = TRUE)",
      "## Finished testing 'df1'                                                   ####",
      " "
    ))
  # Testing names
  expect_equal(
    names(output_12655),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12655),
    21L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12655)),
    21L)
  ## Finished testing 'gxs_selection("df1", out = "return")'                ####

  set_test_seed(10)
  ## Testing 'gxs_selection("tibble::tibble('a' = c(1, 2, ...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_15074 <- gxs_selection("data.table('a' = c(1, 2, 3, 4), 'b' = c('b', 'f', 'g', 's'))", out = "return")
  # Testing class
  expect_equal(
    class(output_15074),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_15074,
    type = "list")
  # Testing values
  expect_equal(
    output_15074,
    list(" ",
         "## Testing 'data.table('a' = c(1, 2, 3, 4), 'b' = c('b', '...'              ####",
         "## Initially generated by xpectr",
         "xpectr::set_test_seed(42)", "# Assigning output", "output_19148 <- data.table('a' = c(1, 2, 3, 4), 'b' = c('b', 'f', 'g', 's'))",
         "# Testing class", "expect_equal(\n  class(output_19148),\n  c(\"data.table\", \"data.frame\"),\n  fixed = TRUE)",
         "# Testing column values", "expect_equal(\n  output_19148[[\"a\"]],\n  c(1, 2, 3, 4),\n  tolerance = 1e-4)",
         "expect_equal(\n  output_19148[[\"b\"]],\n  c(\"b\", \"f\", \"g\", \"s\"),\n  fixed = TRUE)",
         "# Testing column names", "expect_equal(\n  names(output_19148),\n  c(\"a\", \"b\"),\n  fixed = TRUE)",
         "# Testing column classes", "expect_equal(\n  xpectr::element_classes(output_19148),\n  c(\"numeric\", \"character\"),\n  fixed = TRUE)",
         "# Testing column types", "expect_equal(\n  xpectr::element_types(output_19148),\n  c(\"double\", \"character\"),\n  fixed = TRUE)",
         "# Testing dimensions", "expect_equal(\n  dim(output_19148),\n  c(4L, 2L))",
         "# Testing group keys", "expect_equal(\n  colnames(dplyr::group_keys(output_19148)),\n  character(0),\n  fixed = TRUE)",
         "## Finished testing 'data.table('a' = c(1, 2, 3, 4), 'b' = c('b', '...'     ####",
         " "))
  # Testing names
  expect_equal(
    names(output_15074),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_15074),
    23L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_15074)),
    23L)
  ## Finished testing 'gxs_selection("tibble::tibble('a' = c(1, 2, ...'     ####

  df1$c <- list(list(1, 2, 3), list(2, 3, 4, 5), list(2, 3, 7, 21, 2), list(2))

  set_test_seed(1)
  ## Testing 'gxs_selection("df1", out = "return")'                         ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12655 <- xpectr::capture_side_effects(gxs_selection("df1", out = "return"))
  expect_equal(
    xpectr::strip(side_effects_12655[['warnings']]),
    xpectr::strip("Skipped column c."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12655[['messages']]),
    xpectr::strip(character(0)),
    fixed = TRUE)
  # Assigning output
  output_12655 <- xpectr::suppress_mw(gxs_selection("df1", out = "return"))
  # Testing class
  expect_equal(
    class(output_12655),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12655,
    type = "list")
  # Testing values
  expect_equal(
    output_12655,
    list(
      " ",
      "## Testing 'df1'                                                            ####",
      "## Initially generated by xpectr",
      "xpectr::set_test_seed(42)",
      "# Testing class",
      "expect_equal(\n  class(df1),\n  c(\"data.table\", \"data.frame\"),\n  fixed = TRUE)",
      "# Testing column values",
      "expect_equal(\n  df1[[\"a\"]],\n  c(1, 2, 3, 4),\n  tolerance = 1e-4)",
      "expect_equal(\n  df1[[\"b\"]],\n  c(\"a\", \"f\", \"g\", \"s\"),\n  fixed = TRUE)",
      "# Testing column names",
      "expect_equal(\n  names(df1),\n  c(\"a\", \"b\", \"c\"),\n  fixed = TRUE)",
      "# Testing column classes",
      "expect_equal(\n  xpectr::element_classes(df1),\n  c(\"numeric\", \"character\", \"list\"),\n  fixed = TRUE)",
      "# Testing column types",
      "expect_equal(\n  xpectr::element_types(df1),\n  c(\"double\", \"character\", \"list\"),\n  fixed = TRUE)",
      "# Testing dimensions",
      "expect_equal(\n  dim(df1),\n  4:3)",
      "# Testing group keys",
      "expect_equal(\n  colnames(dplyr::group_keys(df1)),\n  character(0),\n  fixed = TRUE)",
      "## Finished testing 'df1'                                                   ####",
      " "
    ))
  # Testing names
  expect_equal(
    names(output_12655),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12655),
    21L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12655)),
    21L)
  ## Finished testing 'gxs_selection("df1", out = "return")'                ####


})

test_that("list of lists expectations are created properly with gxs_selection()", {

  l <- list(list(1, 2, 3), list(2, 3, 4, list(5, 3)), list(2, 3, 7, 21, 2), list(2))

  set_test_seed(20)

  ## Testing 'gxs_selection("l", out = "return")'                           ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_18775 <- gxs_selection("l", out = "return")
  # Testing class
  expect_equal(
    class(output_18775),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_18775,
    type = "list")
  # Testing values
  expect_equal(
    output_18775,
    list(
      " ",
      "## Testing 'l'                                                              ####",
      "## Initially generated by xpectr",
      "xpectr::set_test_seed(42)",
      "# Testing class",
      "expect_equal(\n  class(l),\n  \"list\",\n  fixed = TRUE)",
      "# Testing type",
      "expect_type(\n  l,\n  type = \"list\")",
      "# Testing values",
      paste0("expect_equal(\n  l,\n  list(list(1, 2, 3), list(2, 3, 4, li",
             "st(5, 3)), list(2, 3, 7, 21, \n    2), list(2)))"),
      "# Testing names",
      "expect_equal(\n  names(l),\n  NULL,\n  fixed = TRUE)",
      "# Testing length",
      "expect_equal(\n  length(l),\n  4L)",
      "# Testing sum of element lengths",
      "expect_equal(\n  sum(xpectr::element_lengths(l)),\n  13L)",
      "## Finished testing 'l'                                                     ####",
      " "
    ))
  # Testing names
  expect_equal(
    names(output_18775),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_18775),
    18L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_18775)),
    18L)
  ## Finished testing 'gxs_selection("l", out = "return")'                  ####


  # Long elements (test sampling)
  l2 <- list("a" = 1:6, "b" = 7:12, "c" = 13:18)
  set_test_seed(1)
  ## Testing 'gxs_selection("l2", sample_n = 2, out = "ret...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_12655 <- gxs_selection("l2", sample_n = 2, out = "return")
  # Testing class
  expect_equal(
    class(output_12655),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12655,
    type = "list")
  # Testing values
  expect_equal(
    output_12655,
    list(" ", "## Testing 'l2'                                                             ####",
         "## Initially generated by xpectr",
         "xpectr::set_test_seed(42)", "# Testing class", "expect_equal(\n  class(l2),\n  \"list\",\n  fixed = TRUE)",
         "# Testing type", "expect_type(\n  l2,\n  type = \"list\")",
         "# Testing values", "expect_equal(\n  xpectr::smpl(l2[[\"b\"]], n = 2),\n  c(11, 12),\n  tolerance = 1e-4)",
         "expect_equal(\n  xpectr::smpl(l2[[\"c\"]], n = 2),\n  c(17, 18),\n  tolerance = 1e-4)",
         "# Testing names", "expect_equal(\n  names(xpectr::smpl(l2, n = 2)),\n  c(\"b\", \"c\"),\n  fixed = TRUE)",
         "# Testing length", "expect_equal(\n  length(l2),\n  3L)",
         "# Testing sum of element lengths", "expect_equal(\n  sum(xpectr::element_lengths(l2)),\n  18L)",
         "# Testing element classes", "expect_equal(\n  xpectr::element_classes(l2),\n  c(\"integer\", \"integer\"),\n  fixed = TRUE)",
         "# Testing element types", "expect_equal(\n  xpectr::element_types(l2),\n  c(\"integer\", \"integer\"),\n  fixed = TRUE)",
         "## Finished testing 'l2'                                                    ####",
         " "))
  # Testing names
  expect_equal(
    names(output_12655),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12655),
    23L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12655)),
    23L)
  ## Finished testing 'gxs_selection("l2", sample_n = 2, out = "ret...'     ####

  set_test_seed(2)
  ## Testing 'gxs_selection("l2", sample_n = 4, out = "ret...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_11848 <- gxs_selection("l2", sample_n = 4, out = "return")
  # Testing class
  expect_equal(
    class(output_11848),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_11848,
    type = "list")
  # Testing values
  expect_equal(
    output_11848,
    list(
      " ",
      "## Testing 'l2'                                                             ####",
      "## Initially generated by xpectr",
      "xpectr::set_test_seed(42)",
      "# Testing class",
      "expect_equal(\n  class(l2),\n  \"list\",\n  fixed = TRUE)",
      "# Testing type",
      "expect_type(\n  l2,\n  type = \"list\")",
      "# Testing values",
      "expect_equal(\n  xpectr::smpl(l2[[\"a\"]], n = 4),\n  c(2, 3, 5, 6),\n  tolerance = 1e-4)",
      "expect_equal(\n  xpectr::smpl(l2[[\"b\"]], n = 4),\n  c(8, 9, 11, 12),\n  tolerance = 1e-4)",
      "expect_equal(\n  xpectr::smpl(l2[[\"c\"]], n = 4),\n  c(14, 15, 17, 18),\n  tolerance = 1e-4)",
      "# Testing names",
      "expect_equal(\n  names(l2),\n  c(\"a\", \"b\", \"c\"),\n  fixed = TRUE)",
      "# Testing length",
      "expect_equal(\n  length(l2),\n  3L)",
      "# Testing sum of element lengths",
      "expect_equal(\n  sum(xpectr::element_lengths(l2)),\n  18L)",
      "# Testing element classes",
      "expect_equal(\n  xpectr::element_classes(l2),\n  c(\"integer\", \"integer\", \"integer\"),\n  fixed = TRUE)",
      "# Testing element types",
      "expect_equal(\n  xpectr::element_types(l2),\n  c(\"integer\", \"integer\", \"integer\"),\n  fixed = TRUE)",
      "## Finished testing 'l2'                                                    ####",
      " "
    ))
  # Testing names
  expect_equal(
    names(output_11848),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_11848),
    24L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_11848)),
    24L)
  ## Finished testing 'gxs_selection("l2", sample_n = 4, out = "ret...'     ####


})

test_that("vector expectations are created properly with gxs_selection()", {

  vec_1 <- c(1,2,3,4,5,6,NA)

  ## Testing 'gxs_selection("vec_1", out = "return")'                       ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_18693 <- gxs_selection("vec_1", out = "return")
  # Testing class
  expect_equal(
    class(output_18693),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_18693,
    type = "list")
  # Testing values
  expect_equal(
    output_18693,
    list(
      " ",
      "## Testing 'vec_1'                                                          ####",
      "## Initially generated by xpectr",
      "xpectr::set_test_seed(42)",
      "# Testing class",
      "expect_equal(\n  class(vec_1),\n  \"numeric\",\n  fixed = TRUE)",
      "# Testing type",
      "expect_type(\n  vec_1,\n  type = \"double\")",
      "# Testing values",
      "expect_equal(\n  vec_1,\n  c(1, 2, 3, 4, 5, 6, NA),\n  tolerance = 1e-4)",
      "# Testing names",
      "expect_equal(\n  names(vec_1),\n  NULL,\n  fixed = TRUE)",
      "# Testing length",
      "expect_equal(\n  length(vec_1),\n  7L)",
      "# Testing sum of element lengths",
      "expect_equal(\n  sum(xpectr::element_lengths(vec_1)),\n  7L)",
      "## Finished testing 'vec_1'                                                 ####",
      " "
    ))
  # Testing names
  expect_equal(
    names(output_18693),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_18693),
    18L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_18693)),
    18L)
  ## Finished testing 'gxs_selection("vec_1", out = "return")'              ####

})

test_that("factor expectations are created properly with gxs_selection()", {

  fact_1 <- factor(as.character(c(1,2,3,4,5,6,NA)))

  set_test_seed(29)

  ## Testing 'gxs_selection("fact_1", out = "return")'                      ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_10996 <- gxs_selection("fact_1", out = "return")
  # Testing class
  expect_equal(
    class(output_10996),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_10996,
    type = "character")
  # Testing values
  expect_equal(
    output_10996,
    c(" ",
      "## Testing 'fact_1'                                                         ####",
      "## Initially generated by xpectr",
      "xpectr::set_test_seed(42)", "# Testing is factor", "expect_true(\n  is.factor(fact_1))",
      "# Testing values", "expect_equal(\n  as.character(fact_1),\n  c(\"1\", \"2\", \"3\", \"4\", \"5\", \"6\", NA),\n  fixed = TRUE)",
      "# Testing names", "expect_equal(\n  names(fact_1),\n  NULL,\n  fixed = TRUE)",
      "# Testing length", "expect_equal(\n  length(fact_1),\n  7L)",
      "# Testing number of levels", "expect_equal(\n  nlevels(fact_1),\n  6L)",
      "# Testing levels", "expect_equal(\n  levels(fact_1),\n  c(\"1\", \"2\", \"3\", \"4\", \"5\", \"6\"),\n  fixed = TRUE)",
      "## Finished testing 'fact_1'                                                ####",
      " "),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_10996),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_10996),
    18L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_10996)),
    18L)
  ## Finished testing 'gxs_selection("fact_1", out = "return")'             ####

})

test_that("NULL expectations are created properly with gxs_selection()", {

  set_test_seed(3)
  ## Testing 'gxs_selection("NULL", out = "return")'                        ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_11680 <- gxs_selection("NULL", out = "return")
  # Testing class
  expect_equal(
    class(output_11680),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_11680,
    type = "character")
  # Testing values
  expect_equal(
    output_11680,
    c(" ",
      "## Testing 'NULL'                                                           ####",
      "## Initially generated by xpectr",
      "xpectr::set_test_seed(42)",
      "# Testing is NULL",
      "expect_true(\n  is.null(NULL))",
      "## Finished testing 'NULL'                                                  ####",
      " "
    ),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_11680),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_11680),
    8L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_11680)),
    8L)
  ## Finished testing 'gxs_selection("NULL", out = "return")'               ####

})

test_that("NA expectations are created properly with gxs_selection()", {

  set_test_seed(89)
  ## Testing 'gxs_selection("NA", out = "return")'                          ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_10733 <- gxs_selection("NA", out = "return")
  # Testing class
  expect_equal(
    class(output_10733),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_10733,
    type = "list")
  # Testing values
  expect_equal(
    output_10733,
    list(
      " ",
      "## Testing 'NA'                                                             ####",
      "## Initially generated by xpectr",
      "xpectr::set_test_seed(42)",
      "# Testing class",
      "expect_equal(\n  class(NA),\n  \"logical\",\n  fixed = TRUE)",
      "# Testing type",
      "expect_type(\n  NA,\n  type = \"logical\")",
      "# Testing values",
      "expect_equal(\n  NA,\n  NA)",
      "# Testing names",
      "expect_equal(\n  names(NA),\n  NULL,\n  fixed = TRUE)",
      "# Testing length",
      "expect_equal(\n  length(NA),\n  1L)",
      "# Testing sum of element lengths",
      "expect_equal(\n  sum(xpectr::element_lengths(NA)),\n  1L)",
      "## Finished testing 'NA'                                                    ####",
      " "
    ))
  # Testing names
  expect_equal(
    names(output_10733),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_10733),
    18L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_10733)),
    18L)
  ## Finished testing 'gxs_selection("NA", out = "return")'                 ####

  set_test_seed(58)
  ## Testing 'gxs_selection("NaN", out = "return") '                        ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_13264 <- gxs_selection("NaN", out = "return")
  # Testing class
  expect_equal(
    class(output_13264),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_13264,
    type = "list")
  # Testing values
  expect_equal(
    output_13264,
    list(" ",
         "## Testing 'NaN'                                                            ####",
         "## Initially generated by xpectr",
         "xpectr::set_test_seed(42)", "# Testing class", "expect_equal(\n  class(NaN),\n  \"numeric\",\n  fixed = TRUE)",
         "# Testing type", "expect_type(\n  NaN,\n  type = \"double\")",
         "# Testing values", "expect_equal(\n  NaN,\n  NaN,\n  tolerance = 1e-4)",
         "# Testing names", "expect_equal(\n  names(NaN),\n  NULL,\n  fixed = TRUE)",
         "# Testing length", "expect_equal(\n  length(NaN),\n  1L)",
         "# Testing sum of element lengths", "expect_equal(\n  sum(xpectr::element_lengths(NaN)),\n  1L)",
         "## Finished testing 'NaN'                                                   ####",
         " "))
  # Testing names
  expect_equal(
    names(output_13264),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_13264),
    18L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_13264)),
    18L)
  ## Finished testing 'gxs_selection("NaN", out = "return") '               ####

})

test_that("single number expectations are created properly with gxs_selection()", {

  set_test_seed(293)
  ## Testing 'gxs_selection("1", out = "return")'                           ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_18152 <- gxs_selection("1", out = "return")
  # Testing class
  expect_equal(
    class(output_18152),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_18152,
    type = "list")
  # Testing values
  expect_equal(
    output_18152,
    list(" ",
         "## Testing '1'                                                              ####",
         "## Initially generated by xpectr",
         "xpectr::set_test_seed(42)", "# Testing class", "expect_equal(\n  class(1),\n  \"numeric\",\n  fixed = TRUE)",
         "# Testing type", "expect_type(\n  1,\n  type = \"double\")",
         "# Testing values", "expect_equal(\n  1,\n  1,\n  tolerance = 1e-4)",
         "# Testing names", "expect_equal(\n  names(1),\n  NULL,\n  fixed = TRUE)",
         "# Testing length", "expect_equal(\n  length(1),\n  1L)",
         "# Testing sum of element lengths", "expect_equal(\n  sum(xpectr::element_lengths(1)),\n  1L)",
         "## Finished testing '1'                                                     ####",
         " "))
  # Testing names
  expect_equal(
    names(output_18152),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_18152),
    18L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_18152)),
    18L)
  ## Finished testing 'gxs_selection("1", out = "return")'                  ####


})

test_that("missing variable expectations are created properly with gxs_selection()", {

  set_test_seed(37)

  ## Testing 'gxs_selection("MISSINGVAR", out = "return")'                  ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_15496 <- gxs_selection("MISSINGVAR", out = "return")
  # Testing class
  expect_equal(
    class(output_15496),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_15496,
    type = "list")
  # Testing values
  expect_equal(
    output_15496,
    list(" ", "## Testing 'MISSINGVAR'                                                     ####",
      "## Initially generated by xpectr", "xpectr::set_test_seed(42)",
      "# Testing side effects", "# Assigning side effects", "side_effects_19148 <- xpectr::capture_side_effects(MISSINGVAR, reset_seed = TRUE)",
      "expect_equal(\n  xpectr::strip(side_effects_19148[['error']]),\n  xpectr::strip(\"object 'MISSINGVAR' not found\"),\n  fixed = TRUE)",
      "expect_equal(\n  xpectr::strip(side_effects_19148[['error_class']]),\n  xpectr::strip(c(\"simpleError\", \"error\", \"condition\")),\n  fixed = TRUE)",
      "## Finished testing 'MISSINGVAR'                                            ####",
      " "))
  # Testing names
  expect_equal(
    names(output_15496),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_15496),
    11L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_15496)),
    11L)
  ## Finished testing 'gxs_selection("MISSINGVAR", out = "return")'         ####

})

test_that("function object expectations are created properly with gxs_selection()", {

  f1 <- function(a = "x", b = NULL, c = NA, d){
    paste0(a, b, c, d)
  }

  f2 <- function(){
    NULL
  }

  f3 <- function(x1,x2,x3){
    x1 + x2 + x3
  }

  f4 <- function(x1 = message, x2 = warning, x3 = stop){x1("m"); x2("w"); x3("e")}

  set_test_seed(98)

  ## Testing 'gxs_selection("f1", out = "return")'                          ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_14671 <- gxs_selection("f1", out = "return")
  # Testing class
  expect_equal(
    class(output_14671),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_14671,
    type = "character")
  # Testing values
  expect_equal(
    output_14671,
    c(" ",
      "## Testing 'f1'                                                             ####",
      "## Initially generated by xpectr",
      "xpectr::set_test_seed(42)",
      "# Testing is function",
      "expect_true(\n  is.function(f1))",
      "# Testing argument names and default values",
      "expect_equal(\n  xpectr::simplified_formals(f1),\n  c(\"a = \\\"x\\\"\", \"b = NULL\", \"c = NA\", \"d\"),\n  fixed = TRUE)",
      "# Testing function definition",
      "expect_equal(\n  deparse(f1),\n  c(\"function (a = \\\"x\\\", b = NULL, c = NA, d) \", \"{\", \"    paste0(a, b, c, d)\", \n    \"}\"),\n  fixed = TRUE)",
      "## Finished testing 'f1'                                                    ####",
      " "
    ),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_14671),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_14671),
    12L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_14671)),
    12L)
  ## Finished testing 'gxs_selection("f1", out = "return")'                 ####

  set_test_seed(32)

  ## Testing 'gxs_selection("f2", out = "return")'                          ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_15058 <- gxs_selection("f2", out = "return")
  # Testing class
  expect_equal(
    class(output_15058),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_15058,
    type = "character")
  # Testing values
  expect_equal(
    output_15058,
    c(" ",
      "## Testing 'f2'                                                             ####",
      "## Initially generated by xpectr",
      "xpectr::set_test_seed(42)",
      "# Testing is function",
      "expect_true(\n  is.function(f2))",
      "# Testing argument names and default values",
      "expect_equal(\n  xpectr::simplified_formals(f2),\n  NULL,\n  fixed = TRUE)",
      "# Testing function definition",
      "expect_equal(\n  deparse(f2),\n  c(\"function () \", \"{\", \"    NULL\", \"}\"),\n  fixed = TRUE)",
      "## Finished testing 'f2'                                                    ####",
      " "
    ),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_15058),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_15058),
    12L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_15058)),
    12L)
  ## Finished testing 'gxs_selection("f2", out = "return")'                 ####

  set_test_seed(54)

  ## Testing 'gxs_selection("f3", out = "return")'                          ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19702 <- gxs_selection("f3", out = "return")
  # Testing class
  expect_equal(
    class(output_19702),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19702,
    type = "character")
  # Testing values
  expect_equal(
    output_19702,
    c(" ",
      "## Testing 'f3'                                                             ####",
      "## Initially generated by xpectr",
      "xpectr::set_test_seed(42)",
      "# Testing is function",
      "expect_true(\n  is.function(f3))",
      "# Testing argument names and default values",
      "expect_equal(\n  xpectr::simplified_formals(f3),\n  c(\"x1\", \"x2\", \"x3\"),\n  fixed = TRUE)",
      "# Testing function definition",
      "expect_equal(\n  deparse(f3),\n  c(\"function (x1, x2, x3) \", \"{\", \"    x1 + x2 + x3\", \"}\"),\n  fixed = TRUE)",
      "## Finished testing 'f3'                                                    ####",
      " "
    ),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_19702),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19702),
    12L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19702)),
    12L)
  ## Finished testing 'gxs_selection("f3", out = "return")'                 ####

  set_test_seed(65)

  ## Testing 'gxs_selection("f4", out = "return")'                          ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_11156 <- gxs_selection("f4", out = "return")
  # Testing class
  expect_equal(
    class(output_11156),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_11156,
    type = "character")
  # Testing values
  expect_equal(
    output_11156,
    c(" ",
      "## Testing 'f4'                                                             ####",
      "## Initially generated by xpectr",
      "xpectr::set_test_seed(42)",
      "# Testing is function",
      "expect_true(\n  is.function(f4))",
      "# Testing argument names and default values",
      "expect_equal(\n  xpectr::simplified_formals(f4),\n  c(\"x1 = message\", \"x2 = warning\", \"x3 = stop\"),\n  fixed = TRUE)",
      "# Testing function definition",
      "expect_equal(\n  deparse(f4),\n  c(\"function (x1 = message, x2 = warning, x3 = stop) \", \"{\", \"    x1(\\\"m\\\")\", \n    \"    x2(\\\"w\\\")\", \"    x3(\\\"e\\\")\", \"}\"),\n  fixed = TRUE)",
      "## Finished testing 'f4'                                                    ####",
      " "
    ),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_11156),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_11156),
    12L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_11156)),
    12L)
  ## Finished testing 'gxs_selection("f4", out = "return")'                 ####

  set_test_seed(43)

  # gxs_selection("f4")
  ## Testing 'f4'                                                             ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing is function
  expect_true(
    is.function(f4))
  # Testing argument names and default values
  expect_equal(
    xpectr::simplified_formals(f4),
    c("x1 = message", "x2 = warning", "x3 = stop"),
    fixed = TRUE)
  # Testing function definition
  expect_equal(
    deparse(f4),
    c(
      "function (x1 = message, x2 = warning, x3 = stop) ",
      "{",
      "    x1(\"m\")",
      "    x2(\"w\")",
      "    x3(\"e\")",
      "}"
    ),
    fixed = TRUE)
  ## Finished testing 'f4'                                                    ####


})

test_that("formula expectations are created properly with gxs_selection()", {

  f <- as.formula("e + f * x ~ y + b + d + log(u)")

  set_test_seed(32)

  ## Testing 'gxs_selection("f", out = "return")'                           ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_15058 <- gxs_selection("f", out = "return")
  # Testing class
  expect_equal(
    class(output_15058),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_15058,
    type = "character")
  # Testing values
  expect_equal(
    output_15058,
    c(" ",
      "## Testing 'f'                                                              ####",
      "## Initially generated by xpectr",
      "xpectr::set_test_seed(42)",
      "# Testing is formula",
      "expect_true(\n  rlang::is_formula(f))",
      "# Testing formula",
      "expect_equal(\n  f,\n  e + f * x ~ y + b + d + log(u))",
      "## Finished testing 'f'                                                     ####",
      " "
    ),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_15058),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_15058),
    10L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_15058)),
    10L)
  ## Finished testing 'gxs_selection("f", out = "return")'                  ####

  ## Testing 'f'                                                              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing is formula
  expect_true(
    rlang::is_formula(f))
  # Testing formula
  expect_equal(
    f,
    e + f * x ~ y + b + d + log(u))
  ## Finished testing 'f'                                                     ####

  set_test_seed(1)
  ## Testing 'gxs_selection("t ~ 1 + y + (1| love)", out =...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_12655 <- gxs_selection("t ~ 1 + y + (1| love)", out = "return")
  # Testing class
  expect_equal(
    class(output_12655),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12655,
    type = "character")
  # Testing values
  expect_equal(
    output_12655,
    c(" ",
      "## Testing 't ~ 1 + y + (1| love)'                                          ####",
      "## Initially generated by xpectr",
      "xpectr::set_test_seed(42)",
      "# Assigning output",
      "output_19148 <- t ~ 1 + y + (1| love)",
      "# Testing is formula",
      "expect_true(\n  rlang::is_formula(output_19148))",
      "# Testing formula",
      "expect_equal(\n  output_19148,\n  t ~ 1 + y + (1 | love))",
      "## Finished testing 't ~ 1 + y + (1| love)'                                 ####",
      " "
    ),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_12655),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12655),
    12L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12655)),
    12L)
  ## Finished testing 'gxs_selection("t ~ 1 + y + (1| love)", out =...'     ####


  set_test_seed(23)
  ## Testing 't ~ 1 + y + (1| love)'                                          ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_15766 <- t ~ 1 + y + (1| love)
  # Testing is formula
  expect_true(
    rlang::is_formula(output_15766))
  # Testing formula
  expect_equal(
    output_15766,
    t ~ 1 + y + (1 | love))
  ## Finished testing 't ~ 1 + y + (1| love)'                                 ####


  f_fn <- function(){as.formula("e + f * x ~ y + b + d + log(u)")}

  set_test_seed(1)
  ## Testing 'gxs_selection("f_fn()", out = "return")'                      ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_12655 <- gxs_selection("f_fn()", out = "return")
  # Testing class
  expect_equal(
    class(output_12655),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12655,
    type = "character")
  # Testing values
  expect_equal(
    output_12655,
    c(" ",
      "## Testing 'f_fn()'                                                         ####",
      "## Initially generated by xpectr",
      "xpectr::set_test_seed(42)",
      "# Assigning output",
      "output_19148 <- f_fn()",
      "# Testing is formula",
      "expect_true(\n  rlang::is_formula(output_19148))",
      "# Testing formula",
      "expect_equal(\n  output_19148,\n  e + f * x ~ y + b + d + log(u))",
      "## Finished testing 'f_fn()'                                                ####",
      " "
    ),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_12655),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12655),
    12L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12655)),
    12L)
  ## Finished testing 'gxs_selection("f_fn()", out = "return")'             ####

  set.seed(2)
  ## Testing 'f_fn()'                                                       ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_11848 <- f_fn()
  # Testing is formula
  expect_true(
    rlang::is_formula(output_11848))
  # Testing formula
  expect_equal(
    output_11848,
    e + f * x ~ y + b + d + log(u))
  ## Finished testing 'f_fn()'                                              ####
})

test_that("fallback expectations are created properly with gxs_selection()", {

  set_test_seed(10)

  a <- list(x = 1, y = "f")
  class(a) <- "someclass"
  # Note: This won't work if we make a special case for lists later on

  ## Testing 'gxs_selection("a", out = "return")'                           ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19148 <- xpectr::capture_side_effects(gxs_selection("a", out = "return"))
  expect_equal(
    xpectr::strip(side_effects_19148[['warnings']]),
    xpectr::strip("The selection is not of a currently supported class 'someclass'. Will generate fallback tests."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['messages']]),
    xpectr::strip(character(0)),
    fixed = TRUE)
  # Assigning output
  output_19148 <- xpectr::suppress_mw(gxs_selection("a", out = "return"))
  # Testing class
  expect_equal(
    class(output_19148),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "character")
  # Testing values
  expect_equal(
    output_19148,
    c(
      " ",
      "## Testing 'a'                                                              ####",
      "## Initially generated by xpectr",
      "xpectr::set_test_seed(42)",
      "# Unsupported class: using fallback tests",
      "# Testing class",
      "expect_equal(\n  class(a),\n  \"someclass\",\n  fixed = TRUE)",
      "# Testing type",
      "expect_type(\n  a,\n  type = \"list\")",
      "# Testing names",
      "expect_equal(\n  names(a),\n  c(\"x\", \"y\"),\n  fixed = TRUE)",
      "# Testing dput() content",
      "expect_equal(\n  a,\n  structure(list(x = 1, y = \"f\"), class = \"someclass\"))",
      "## Finished testing 'a'                                                     ####",
      " "
    ),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    15L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    15L)
  ## Finished testing 'gxs_selection("a", out = "return")'                  ####


})

test_that("matrix expectations are created properly with gxs_selection()", {

  # TODO Once you can get access to R 4.0.0 (or devel from after 01-28-2020)
  # Make sure this works on that version of R as well!
  if (getRversion()$major > 3 || getRversion()$minor > 6){
    testthat::skip("skipping due to breaking changes in R 4.0.0")
  }

  set_test_seed(1)
  m_num <- matrix(runif(12), 4, 3)
  m_char <- matrix(as.character(runif(12)), 3, 4)
  m_symm <- matrix(1, 3, 3)

  set_test_seed(1)
  ## Testing 'gxs_selection("matrix(runif(12), 4, 3)", out...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_12655 <- gxs_selection("matrix(runif(12), 4, 3)", out = "return")
  # Testing class
  expect_equal(
    class(output_12655),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12655,
    type = "list")
  # Testing values
  expect_equal(
    output_12655,
    list(
      " ",
      "## Testing 'matrix(runif(12), 4, 3)'                                        ####",
      "## Initially generated by xpectr",
      "xpectr::set_test_seed(42)",
      "# Assigning output",
      "output_19148 <- matrix(runif(12), 4, 3)",
      "# Testing class",
      "expect_equal(\n  class(output_19148)[[1]],\n  \"matrix\",\n  fixed = TRUE)",
      "# Testing type",
      "expect_type(\n  output_19148,\n  type = \"double\")",
      "# Testing column values",
      "expect_equal(\n  output_19148[, 1],\n  c(0.91481, 0.93708, 0.28614, 0.83045),\n  tolerance = 1e-4)",
      "expect_equal(\n  output_19148[, 2],\n  c(0.64175, 0.5191, 0.73659, 0.13467),\n  tolerance = 1e-4)",
      "expect_equal(\n  output_19148[, 3],\n  c(0.65699, 0.70506, 0.45774, 0.71911),\n  tolerance = 1e-4)",
      "# Testing column names",
      "expect_equal(\n  colnames(output_19148),\n  NULL,\n  fixed = TRUE)",
      "# Testing row names",
      "expect_equal(\n  rownames(output_19148),\n  NULL,\n  fixed = TRUE)",
      "# Testing dimensions",
      "expect_equal(\n  dim(output_19148),\n  4:3)",
      "# Testing symmetry",
      "expect_true(\n  !isSymmetric(output_19148))",
      "## Finished testing 'matrix(runif(12), 4, 3)'                               ####",
      " "
    ))
  # Testing names
  expect_equal(
    names(output_12655),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12655),
    24L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12655)),
    24L)
  ## Finished testing 'gxs_selection("matrix(runif(12), 4, 3)", out...'     ####


  set_test_seed(1)
  # gxs_selection("matrix(runif(12), 4, 3)")
  ## Testing 'matrix(runif(12), 4, 3)'                                      ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_12655 <- matrix(runif(12), 4, 3)
  # Testing class
  expect_equal(
    class(output_12655)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12655,
    type = "double")
  # Testing column values
  expect_equal(
    output_12655[, 1],
    c(0.91481, 0.93708, 0.28614, 0.83045),
    tolerance = 1e-4)
  expect_equal(
    output_12655[, 2],
    c(0.64175, 0.5191, 0.73659, 0.13467),
    tolerance = 1e-4)
  expect_equal(
    output_12655[, 3],
    c(0.65699, 0.70506, 0.45774, 0.71911),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(output_12655),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(output_12655),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_12655),
    4:3)
  # Testing symmetry
  expect_true(
    !isSymmetric(output_12655))
  ## Finished testing 'matrix(runif(12), 4, 3)'                             ####

  set_test_seed(1)
  ## Testing 'gxs_selection("m_num", out = "return")'                       ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_12655 <- gxs_selection("m_num", out = "return")
  # Testing class
  expect_equal(
    class(output_12655),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12655,
    type = "list")
  # Testing values
  expect_equal(
    output_12655,
    list(
      " ",
      "## Testing 'm_num'                                                          ####",
      "## Initially generated by xpectr",
      "xpectr::set_test_seed(42)",
      "# Testing class",
      "expect_equal(\n  class(m_num)[[1]],\n  \"matrix\",\n  fixed = TRUE)",
      "# Testing type",
      "expect_type(\n  m_num,\n  type = \"double\")",
      "# Testing column values",
      "expect_equal(\n  m_num[, 1],\n  c(0.26551, 0.37212, 0.57285, 0.90821),\n  tolerance = 1e-4)",
      "expect_equal(\n  m_num[, 2],\n  c(0.20168, 0.89839, 0.94468, 0.6608),\n  tolerance = 1e-4)",
      "expect_equal(\n  m_num[, 3],\n  c(0.62911, 0.06179, 0.20597, 0.17656),\n  tolerance = 1e-4)",
      "# Testing column names",
      "expect_equal(\n  colnames(m_num),\n  NULL,\n  fixed = TRUE)",
      "# Testing row names",
      "expect_equal(\n  rownames(m_num),\n  NULL,\n  fixed = TRUE)",
      "# Testing dimensions",
      "expect_equal(\n  dim(m_num),\n  4:3)",
      "# Testing symmetry",
      "expect_true(\n  !isSymmetric(m_num))",
      "## Finished testing 'm_num'                                                 ####",
      " "))
  # Testing names
  expect_equal(
    names(output_12655),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12655),
    22L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12655)),
    22L)
  ## Finished testing 'gxs_selection("m_num", out = "return")'              ####


  set_test_seed(1)
  # gxs_selection("m_num")
  ## Testing 'm_num'                                                        ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(m_num)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    m_num,
    type = "double")
  # Testing column values
  expect_equal(
    m_num[, 1],
    c(0.26551, 0.37212, 0.57285, 0.90821),
    tolerance = 1e-4)
  expect_equal(
    m_num[, 2],
    c(0.20168, 0.89839, 0.94468, 0.6608),
    tolerance = 1e-4)
  expect_equal(
    m_num[, 3],
    c(0.62911, 0.06179, 0.20597, 0.17656),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(m_num),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(m_num),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(m_num),
    4:3)
  # Testing symmetry
  expect_true(
    !isSymmetric(m_num))
  ## Finished testing 'm_num'                                               ####


  set_test_seed(1)
  ## Testing 'gxs_selection("m_char", out = "return")'                      ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_12655 <- gxs_selection("m_char", out = "return")
  # Testing class
  expect_equal(
    class(output_12655),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12655,
    type = "list")
  # Testing values
  expect_equal(
    output_12655,
    list(
      " ",
      "## Testing 'm_char'                                                         ####",
      "## Initially generated by xpectr",
      "xpectr::set_test_seed(42)",
      "# Testing class",
      "expect_equal(\n  class(m_char)[[1]],\n  \"matrix\",\n  fixed = TRUE)",
      "# Testing type",
      "expect_type(\n  m_char,\n  type = \"character\")",
      "# Testing row values",
      "expect_equal(\n  m_char[1, ],\n  c(\"0.687022846657783\", \"0.497699242085218\", \"0.380035179434344\", \n    \"0.212142521282658\"),\n  fixed = TRUE)",
      "expect_equal(\n  m_char[2, ],\n  c(\"0.384103718213737\", \"0.717618508264422\", \"0.777445221319795\", \n    \"0.651673766085878\"),\n  fixed = TRUE)",
      "expect_equal(\n  m_char[3, ],\n  c(\"0.769841419998556\", \"0.991906094830483\", \"0.934705231105909\", \n    \"0.125555095961317\"),\n  fixed = TRUE)",
      "# Testing column names",
      "expect_equal(\n  colnames(m_char),\n  NULL,\n  fixed = TRUE)",
      "# Testing row names",
      "expect_equal(\n  rownames(m_char),\n  NULL,\n  fixed = TRUE)",
      "# Testing dimensions",
      "expect_equal(\n  dim(m_char),\n  3:4)",
      "# Testing symmetry",
      "expect_true(\n  !isSymmetric(m_char))",
      "## Finished testing 'm_char'                                                ####",
      " "
    ))
  # Testing names
  expect_equal(
    names(output_12655),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12655),
    22L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12655)),
    22L)
  ## Finished testing 'gxs_selection("m_char", out = "return")'             ####

  set_test_seed(1)
  # gxs_selection("m_char")
  ## Testing 'm_char'                                                       ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(m_char)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    m_char,
    type = "character")
  # Testing row values
  expect_equal(
    m_char[1, ],
    c("0.687022846657783", "0.497699242085218", "0.380035179434344",
      "0.212142521282658"),
    fixed = TRUE)
  expect_equal(
    m_char[2, ],
    c("0.384103718213737", "0.717618508264422", "0.777445221319795",
      "0.651673766085878"),
    fixed = TRUE)
  expect_equal(
    m_char[3, ],
    c("0.769841419998556", "0.991906094830483", "0.934705231105909",
      "0.125555095961317"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    colnames(m_char),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(m_char),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(m_char),
    3:4)
  # Testing symmetry
  expect_true(
    !isSymmetric(m_char))
  ## Finished testing 'm_char'                                              ####


  set_test_seed(1)
  ## Testing 'gxs_selection("m_symm", out = "return")'                      ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_12655 <- gxs_selection("m_symm", out = "return")
  # Testing class
  expect_equal(
    class(output_12655),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12655,
    type = "list")
  # Testing values
  expect_equal(
    output_12655,
    list(" ",
         "## Testing 'm_symm'                                                         ####",
         "## Initially generated by xpectr",
         "xpectr::set_test_seed(42)", "# Testing class", "expect_equal(\n  class(m_symm)[[1]],\n  \"matrix\",\n  fixed = TRUE)",
         "# Testing type", "expect_type(\n  m_symm,\n  type = \"double\")",
         "# Testing column values", "expect_equal(\n  m_symm[, 1],\n  c(1, 1, 1),\n  tolerance = 1e-4)",
         "expect_equal(\n  m_symm[, 2],\n  c(1, 1, 1),\n  tolerance = 1e-4)",
         "expect_equal(\n  m_symm[, 3],\n  c(1, 1, 1),\n  tolerance = 1e-4)",
         "# Testing column names", "expect_equal(\n  colnames(m_symm),\n  NULL,\n  fixed = TRUE)",
         "# Testing row names", "expect_equal(\n  rownames(m_symm),\n  NULL,\n  fixed = TRUE)",
         "# Testing dimensions", "expect_equal(\n  dim(m_symm),\n  c(3L, 3L))",
         "# Testing symmetry", "expect_true(\n  isSymmetric(m_symm))",
         "## Finished testing 'm_symm'                                                ####",
         " "))
  # Testing names
  expect_equal(
    names(output_12655),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12655),
    22L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12655)),
    22L)
  ## Finished testing 'gxs_selection("m_symm", out = "return")'             ####


  set_test_seed(1)
  # gxs_selection("m_symm")
  ## Testing 'm_symm'                                                       ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(m_symm)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    m_symm,
    type = "double")
  # Testing column values
  expect_equal(
    m_symm[, 1],
    c(1, 1, 1),
    tolerance = 1e-4)
  expect_equal(
    m_symm[, 2],
    c(1, 1, 1),
    tolerance = 1e-4)
  expect_equal(
    m_symm[, 3],
    c(1, 1, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(m_symm),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(m_symm),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(m_symm),
    c(3L, 3L))
  # Testing symmetry
  expect_true(
    isSymmetric(m_symm))
  ## Finished testing 'm_symm'                                              ####

})

test_that("table expectations are created properly with gxs_selection()", {

  # TODO Once you can get access to R 4.0.0 (or devel from after 01-28-2020)
  # Make sure this works on that version of R as well!
  if (getRversion()$major > 3 || getRversion()$minor > 6){
    testthat::skip("skipping due to breaking changes in R 4.0.0")
  }

  set_test_seed(1)

  table_num <- table(c(1,1,1,2,2,2,3,3,3), c(2,1,2,3,2,3,2,1,3))
  table_chr <- table(as.character(c(1,1,1,2,2,2,3,3,3)),
                     as.character(c(2,1,2,3,2,3,2,1,3)))
  table_diff_levels <- table(c(1,3,1,2,3,2,4,4,4), c(2,1,2,3,2,3,2,1,3))

  set_test_seed(1)

  ## Testing 'gxs_selection("table_num", out = "return")'                   ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_12655 <- gxs_selection("table_num", out = "return")
  # Testing class
  expect_equal(
    class(output_12655),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12655,
    type = "list")
  # Testing values
  expect_equal(
    output_12655,
    list(
      " ",
      "## Testing 'table_num'                                                      ####",
      "## Initially generated by xpectr",
      "xpectr::set_test_seed(42)",
      "# Testing class",
      "expect_equal(\n  class(table_num)[[1]],\n  \"table\",\n  fixed = TRUE)",
      "# Testing type",
      "expect_type(\n  table_num,\n  type = \"integer\")",
      "# Testing column values",
      "expect_equal(\n  table_num[, 1],\n  c(`1` = 1, `2` = 0, `3` = 1),\n  tolerance = 1e-4)",
      "expect_equal(\n  table_num[, 2],\n  c(`1` = 2, `2` = 1, `3` = 1),\n  tolerance = 1e-4)",
      "expect_equal(\n  table_num[, 3],\n  c(`1` = 0, `2` = 2, `3` = 1),\n  tolerance = 1e-4)",
      "# Testing column names",
      "expect_equal(\n  colnames(table_num),\n  c(\"1\", \"2\", \"3\"),\n  fixed = TRUE)",
      "# Testing row names",
      "expect_equal(\n  rownames(table_num),\n  c(\"1\", \"2\", \"3\"),\n  fixed = TRUE)",
      "# Testing dimensions",
      "expect_equal(\n  dim(table_num),\n  c(3L, 3L))",
      "## Finished testing 'table_num'                                             ####",
      " "
    ))
  # Testing names
  expect_equal(
    names(output_12655),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12655),
    20L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12655)),
    20L)
  ## Finished testing 'gxs_selection("table_num", out = "return")'          ####

  # Check that the expectations work

  ## Testing 'table_num'                                                    ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(table_num)[[1]],
    "table",
    fixed = TRUE)
  # Testing type
  expect_type(
    table_num,
    type = "integer")
  # Testing column values
  expect_equal(
    table_num[, 1],
    c(`1` = 1, `2` = 0, `3` = 1),
    tolerance = 1e-4)
  expect_equal(
    table_num[, 2],
    c(`1` = 2, `2` = 1, `3` = 1),
    tolerance = 1e-4)
  expect_equal(
    table_num[, 3],
    c(`1` = 0, `2` = 2, `3` = 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(table_num),
    c("1", "2", "3"),
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(table_num),
    c("1", "2", "3"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(table_num),
    c(3L, 3L))
  ## Finished testing 'table_num'                                           ####


  ### Table character

  ## Testing 'gxs_selection("table_chr", out = "return")'                   ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- gxs_selection("table_chr", out = "return")
  # Testing class
  expect_equal(
    class(output_19148),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "list")
  # Testing values
  expect_equal(
    output_19148,
    list(" ", "## Testing 'table_chr'                                                      ####",
      "## Initially generated by xpectr", "xpectr::set_test_seed(42)",
      "# Testing class", "expect_equal(\n  class(table_chr)[[1]],\n  \"table\",\n  fixed = TRUE)",
      "# Testing type", "expect_type(\n  table_chr,\n  type = \"integer\")",
      "# Testing column values", "expect_equal(\n  table_chr[, 1],\n  c(`1` = 1, `2` = 0, `3` = 1),\n  tolerance = 1e-4)",
      "expect_equal(\n  table_chr[, 2],\n  c(`1` = 2, `2` = 1, `3` = 1),\n  tolerance = 1e-4)",
      "expect_equal(\n  table_chr[, 3],\n  c(`1` = 0, `2` = 2, `3` = 1),\n  tolerance = 1e-4)",
      "# Testing column names", "expect_equal(\n  colnames(table_chr),\n  c(\"1\", \"2\", \"3\"),\n  fixed = TRUE)",
      "# Testing row names", "expect_equal(\n  rownames(table_chr),\n  c(\"1\", \"2\", \"3\"),\n  fixed = TRUE)",
      "# Testing dimensions", "expect_equal(\n  dim(table_chr),\n  c(3L, 3L))",
      "## Finished testing 'table_chr'                                             ####",
      " "))
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    20L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    20L)
  ## Finished testing 'gxs_selection("table_chr", out = "return")'          ####


  ## Testing 'table_chr'                                                    ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(table_chr)[[1]],
    "table",
    fixed = TRUE)
  # Testing type
  expect_type(
    table_chr,
    type = "integer")
  # Testing column values
  expect_equal(
    table_chr[, 1],
    c(`1` = 1, `2` = 0, `3` = 1),
    tolerance = 1e-4)
  expect_equal(
    table_chr[, 2],
    c(`1` = 2, `2` = 1, `3` = 1),
    tolerance = 1e-4)
  expect_equal(
    table_chr[, 3],
    c(`1` = 0, `2` = 2, `3` = 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(table_chr),
    c("1", "2", "3"),
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(table_chr),
    c("1", "2", "3"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(table_chr),
    c(3L, 3L))
  ## Finished testing 'table_chr'                                           ####

  # Table with differing levels per axis

  ## Testing 'gxs_selection("table_diff_levels", out = "re...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- gxs_selection("table_diff_levels", out = "return")
  # Testing class
  expect_equal(
    class(output_19148),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "list")
  # Testing values
  expect_equal(
    output_19148,
    list(" ", "## Testing 'table_diff_levels'                                              ####",
      "## Initially generated by xpectr", "xpectr::set_test_seed(42)",
      "# Testing class", "expect_equal(\n  class(table_diff_levels)[[1]],\n  \"table\",\n  fixed = TRUE)",
      "# Testing type", "expect_type(\n  table_diff_levels,\n  type = \"integer\")",
      "# Testing column values", "expect_equal(\n  table_diff_levels[, 1],\n  c(`1` = 0, `2` = 0, `3` = 1, `4` = 1),\n  tolerance = 1e-4)",
      "expect_equal(\n  table_diff_levels[, 2],\n  c(`1` = 2, `2` = 0, `3` = 1, `4` = 1),\n  tolerance = 1e-4)",
      "expect_equal(\n  table_diff_levels[, 3],\n  c(`1` = 0, `2` = 2, `3` = 0, `4` = 1),\n  tolerance = 1e-4)",
      "# Testing column names", "expect_equal(\n  colnames(table_diff_levels),\n  c(\"1\", \"2\", \"3\"),\n  fixed = TRUE)",
      "# Testing row names", "expect_equal(\n  rownames(table_diff_levels),\n  c(\"1\", \"2\", \"3\", \"4\"),\n  fixed = TRUE)",
      "# Testing dimensions", "expect_equal(\n  dim(table_diff_levels),\n  4:3)",
      "## Finished testing 'table_diff_levels'                                     ####",
      " "))
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    20L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    20L)
  ## Finished testing 'gxs_selection("table_diff_levels", out = "re...'     ####


  ## Testing 'table_diff_levels'                                            ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(table_diff_levels)[[1]],
    "table",
    fixed = TRUE)
  # Testing type
  expect_type(
    table_diff_levels,
    type = "integer")
  # Testing column values
  expect_equal(
    table_diff_levels[, 1],
    c(`1` = 0, `2` = 0, `3` = 1, `4` = 1),
    tolerance = 1e-4)
  expect_equal(
    table_diff_levels[, 2],
    c(`1` = 2, `2` = 0, `3` = 1, `4` = 1),
    tolerance = 1e-4)
  expect_equal(
    table_diff_levels[, 3],
    c(`1` = 0, `2` = 2, `3` = 0, `4` = 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(table_diff_levels),
    c("1", "2", "3"),
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(table_diff_levels),
    c("1", "2", "3", "4"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(table_diff_levels),
    4:3)
  ## Finished testing 'table_diff_levels'                                   ####

})

test_that("round_to_tolerance argument is properly used", {

  set_test_seed(1)
  df_1 <- data.frame("a" = runif(10), "b" = runif(10))
  set_test_seed(1)
  l_1 <- list("a" = runif(10), "b" = runif(10))
  set_test_seed(1)
  l_2 <- list("a" = runif(10), runif(10))
  set_test_seed(1)
  v_1 <- c(runif(10), runif(10))

  set_test_seed(32)
  ## Testing 'gxs_selection("df_1", tolerance = "1e-6", ro...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_15058 <- gxs_selection("df_1", tolerance = "1e-6", round_to_tolerance = TRUE, out = "return")
  # Testing class
  expect_equal(
    class(output_15058),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_15058,
    type = "list")
  # Testing values
  expect_equal(
    output_15058,
    list(
      " ",
      "## Testing 'df_1'                                                           ####",
      "## Initially generated by xpectr",
      "xpectr::set_test_seed(42)",
      "# Testing class",
      "expect_equal(\n  class(df_1),\n  \"data.frame\",\n  fixed = TRUE)",
      "# Testing column values",
      "expect_equal(\n  df_1[[\"a\"]],\n  c(0.2655087, 0.3721239, 0.5728534, 0.9082078, 0.2016819, 0.8983897, \n    0.9446753, 0.6607978, 0.629114, 0.0617863),\n  tolerance = 1e-6)",
      "expect_equal(\n  df_1[[\"b\"]],\n  c(0.2059746, 0.1765568, 0.6870228, 0.3841037, 0.7698414, 0.4976992, \n    0.7176185, 0.9919061, 0.3800352, 0.7774452),\n  tolerance = 1e-6)",
      "# Testing column names",
      "expect_equal(\n  names(df_1),\n  c(\"a\", \"b\"),\n  fixed = TRUE)",
      "# Testing column classes",
      "expect_equal(\n  xpectr::element_classes(df_1),\n  c(\"numeric\", \"numeric\"),\n  fixed = TRUE)",
      "# Testing column types",
      "expect_equal(\n  xpectr::element_types(df_1),\n  c(\"double\", \"double\"),\n  fixed = TRUE)",
      "# Testing dimensions",
      "expect_equal(\n  dim(df_1),\n  c(10L, 2L))",
      "# Testing group keys",
      "expect_equal(\n  colnames(dplyr::group_keys(df_1)),\n  character(0),\n  fixed = TRUE)",
      "## Finished testing 'df_1'                                                  ####",
      " "
    ))
  # Testing names
  expect_equal(
    names(output_15058),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_15058),
    21L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_15058)),
    21L)
  ## Finished testing 'gxs_selection("df_1", tolerance = "1e-6", ro...'     ####


  set_test_seed(35)

  ## Testing 'gxs_selection("df_1", tolerance = "1e-6", ro...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_18565 <- gxs_selection("df_1", tolerance = "1e-6", round_to_tolerance = FALSE, out = "return")
  # Testing class
  expect_equal(
    class(output_18565),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_18565,
    type = "list")
  # Testing values
  expect_equal(
    output_18565,
    list(
      " ",
      "## Testing 'df_1'                                                           ####",
      "## Initially generated by xpectr",
      "xpectr::set_test_seed(42)",
      "# Testing class",
      "expect_equal(\n  class(df_1),\n  \"data.frame\",\n  fixed = TRUE)",
      "# Testing column values",
      "expect_equal(\n  df_1[[\"a\"]],\n  c(0.2655086631421, 0.37212389963679, 0.572853363351896, 0.908207789994776, \n    0.201681931037456, 0.898389684967697, 0.944675268605351, 0.660797792486846, \n    0.62911404389888, 0.0617862704675645),\n  tolerance = 1e-6)",
      "expect_equal(\n  df_1[[\"b\"]],\n  c(0.205974574899301, 0.176556752528995, 0.687022846657783, 0.384103718213737, \n    0.769841419998556, 0.497699242085218, 0.717618508264422, 0.991906094830483, \n    0.380035179434344, 0.777445221319795),\n  tolerance = 1e-6)",
      "# Testing column names",
      "expect_equal(\n  names(df_1),\n  c(\"a\", \"b\"),\n  fixed = TRUE)",
      "# Testing column classes",
      "expect_equal(\n  xpectr::element_classes(df_1),\n  c(\"numeric\", \"numeric\"),\n  fixed = TRUE)",
      "# Testing column types",
      "expect_equal(\n  xpectr::element_types(df_1),\n  c(\"double\", \"double\"),\n  fixed = TRUE)",
      "# Testing dimensions",
      "expect_equal(\n  dim(df_1),\n  c(10L, 2L))",
      "# Testing group keys",
      "expect_equal(\n  colnames(dplyr::group_keys(df_1)),\n  character(0),\n  fixed = TRUE)",
      "## Finished testing 'df_1'                                                  ####",
      " "
    ))
  # Testing names
  expect_equal(
    names(output_18565),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_18565),
    21L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_18565)),
    21L)
  ## Finished testing 'gxs_selection("df_1", tolerance = "1e-6", ro...'     ####


  set_test_seed(98)

  ## Testing 'gxs_selection("l_1", tolerance = "1e-6", rou...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_14671 <- gxs_selection("l_1", tolerance = "1e-6", round_to_tolerance = TRUE, out = "return")
  # Testing class
  expect_equal(
    class(output_14671),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_14671,
    type = "list")
  # Testing values
  expect_equal(
    output_14671,
    list(" ",
         "## Testing 'l_1'                                                            ####",
         "## Initially generated by xpectr",
         "xpectr::set_test_seed(42)", "# Testing class", "expect_equal(\n  class(l_1),\n  \"list\",\n  fixed = TRUE)",
         "# Testing type", "expect_type(\n  l_1,\n  type = \"list\")",
         "# Testing values", "expect_equal(\n  l_1[[\"a\"]],\n  c(0.2655087, 0.3721239, 0.5728534, 0.9082078, 0.2016819, 0.8983897, \n    0.9446753, 0.6607978, 0.629114, 0.0617863),\n  tolerance = 1e-6)",
         "expect_equal(\n  l_1[[\"b\"]],\n  c(0.2059746, 0.1765568, 0.6870228, 0.3841037, 0.7698414, 0.4976992, \n    0.7176185, 0.9919061, 0.3800352, 0.7774452),\n  tolerance = 1e-6)",
         "# Testing names", "expect_equal(\n  names(l_1),\n  c(\"a\", \"b\"),\n  fixed = TRUE)",
         "# Testing length", "expect_equal(\n  length(l_1),\n  2L)",
         "# Testing sum of element lengths", "expect_equal(\n  sum(xpectr::element_lengths(l_1)),\n  20L)",
         "# Testing element classes", "expect_equal(\n  xpectr::element_classes(l_1),\n  c(\"numeric\", \"numeric\"),\n  fixed = TRUE)",
         "# Testing element types", "expect_equal(\n  xpectr::element_types(l_1),\n  c(\"double\", \"double\"),\n  fixed = TRUE)",
         "## Finished testing 'l_1'                                                   ####",
         " "))
  # Testing names
  expect_equal(
    names(output_14671),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_14671),
    23L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_14671)),
    23L)
  ## Finished testing 'gxs_selection("l_1", tolerance = "1e-6", rou...'     ####

  set_test_seed(67)

  ## Testing 'gxs_selection("l_1", tolerance = "1e-6", rou...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_18886 <- gxs_selection("l_1", tolerance = "1e-6", round_to_tolerance = FALSE, out = "return")
  # Testing class
  expect_equal(
    class(output_18886),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_18886,
    type = "list")
  # Testing values
  expect_equal(
    output_18886,
    list(" ",
         "## Testing 'l_1'                                                            ####",
         "## Initially generated by xpectr",
         "xpectr::set_test_seed(42)", "# Testing class", "expect_equal(\n  class(l_1),\n  \"list\",\n  fixed = TRUE)",
         "# Testing type", "expect_type(\n  l_1,\n  type = \"list\")",
         "# Testing values", "expect_equal(\n  l_1[[\"a\"]],\n  c(0.2655086631421, 0.37212389963679, 0.572853363351896, 0.908207789994776, \n    0.201681931037456, 0.898389684967697, 0.944675268605351, 0.660797792486846, \n    0.62911404389888, 0.0617862704675645),\n  tolerance = 1e-6)",
         "expect_equal(\n  l_1[[\"b\"]],\n  c(0.205974574899301, 0.176556752528995, 0.687022846657783, 0.384103718213737, \n    0.769841419998556, 0.497699242085218, 0.717618508264422, 0.991906094830483, \n    0.380035179434344, 0.777445221319795),\n  tolerance = 1e-6)",
         "# Testing names", "expect_equal(\n  names(l_1),\n  c(\"a\", \"b\"),\n  fixed = TRUE)",
         "# Testing length", "expect_equal(\n  length(l_1),\n  2L)",
         "# Testing sum of element lengths", "expect_equal(\n  sum(xpectr::element_lengths(l_1)),\n  20L)",
         "# Testing element classes", "expect_equal(\n  xpectr::element_classes(l_1),\n  c(\"numeric\", \"numeric\"),\n  fixed = TRUE)",
         "# Testing element types", "expect_equal(\n  xpectr::element_types(l_1),\n  c(\"double\", \"double\"),\n  fixed = TRUE)",
         "## Finished testing 'l_1'                                                   ####",
         " "))
  # Testing names
  expect_equal(
    names(output_18886),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_18886),
    23L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_18886)),
    23L)
  ## Finished testing 'gxs_selection("l_1", tolerance = "1e-6", rou...'     ####

  set_test_seed(43)

  # This doesn't round. May consider working on this later. Not sure it would work
  # with the tolerance arg in expect_equal though?
  # gxs_selection("l_2", tolerance = "1e-6", round_to_tolerance = TRUE, out = "return")

  ## Testing 'gxs_selection("l_2", tolerance = "1e-6", rou...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_14850 <- gxs_selection("l_2", tolerance = "1e-6", round_to_tolerance = TRUE, out = "return")
  # Testing class
  expect_equal(
    class(output_14850),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_14850,
    type = "list")
  # Testing values
  expect_equal(
    output_14850,
    list(
      " ",
      "## Testing 'l_2'                                                            ####",
      "## Initially generated by xpectr",
      "xpectr::set_test_seed(42)",
      "# Testing class",
      "expect_equal(\n  class(l_2),\n  \"list\",\n  fixed = TRUE)",
      "# Testing type",
      "expect_type(\n  l_2,\n  type = \"list\")",
      "# Testing values",
      paste0(
        "expect_equal(\n  l_2,\n  list(a = c(0.2",
        "655086631421, 0.37212389963679, 0.572853363351896, \n    0.908207",
        "789994776, 0.201681931037456, 0.898389684967697, 0.944675268",
        "605351, \n    0.660797792486846, 0.62911404389888, 0.061786270467",
        "5645), c(0.205974574899301, \n    0.176556752528995, 0.6870228466",
        "57783, 0.384103718213737, 0.769841419998556, \n    0.497699242085",
        "218, 0.717618508264422, 0.991906094830483, 0.380035179434344",
        ", \n    0.777445221319795)))"
      ),
      "# Testing names",
      "expect_equal(\n  names(l_2),\n  c(\"a\", \"\"),\n  fixed = TRUE)",
      "# Testing length",
      "expect_equal(\n  length(l_2),\n  2L)",
      "# Testing sum of element lengths",
      "expect_equal(\n  sum(xpectr::element_lengths(l_2)),\n  20L)",
      "## Finished testing 'l_2'                                                   ####",
      " "
    ))
  # Testing names
  expect_equal(
    names(output_14850),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_14850),
    18L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_14850)),
    18L)
  ## Finished testing 'gxs_selection("l_2", tolerance = "1e-6", rou...'     ####


  set_test_seed(876)

  ## Testing 'gxs_selection("v_1", tolerance = "1e-6", rou...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_15678 <- gxs_selection("v_1", tolerance = "1e-6", round_to_tolerance = TRUE, out = "return")
  # Testing class
  expect_equal(
    class(output_15678),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_15678,
    type = "list")
  # Testing values
  expect_equal(
    output_15678,
    list(" ",
         "## Testing 'v_1'                                                            ####",
         "## Initially generated by xpectr",
         "xpectr::set_test_seed(42)", "# Testing class", "expect_equal(\n  class(v_1),\n  \"numeric\",\n  fixed = TRUE)",
         "# Testing type", "expect_type(\n  v_1,\n  type = \"double\")",
         "# Testing values",
         paste0("expect_equal(\n  v_1,\n  c(0.2655087, 0",
                ".3721239, 0.5728534, 0.9082078, 0.2016819, 0.8983897, \n    0.944",
                "6753, 0.6607978, 0.629114, 0.0617863, 0.2059746, 0.1765568,",
                " \n    0.6870228, 0.3841037, 0.7698414, 0.4976992, 0.7176185, 0.99",
                "19061, \n    0.3800352, 0.7774452),\n  tolerance = 1e-6)"),
         "# Testing names", "expect_equal(\n  names(v_1),\n  NULL,\n  fixed = TRUE)",
         "# Testing length", "expect_equal(\n  length(v_1),\n  20L)",
         "# Testing sum of element lengths", "expect_equal(\n  sum(xpectr::element_lengths(v_1)),\n  20L)",
         "## Finished testing 'v_1'                                                   ####",
         " "))
  # Testing names
  expect_equal(
    names(output_15678),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_15678),
    18L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_15678)),
    18L)
  ## Finished testing 'gxs_selection("v_1", tolerance = "1e-6", rou...'     ####

  set_test_seed(45)

  ## Testing 'gxs_selection("v_1", tolerance = "1e-6", rou...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_16333 <- gxs_selection("v_1", tolerance = "1e-6", round_to_tolerance = FALSE, out = "return")
  # Testing class
  expect_equal(
    class(output_16333),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_16333,
    type = "list")
  # Testing values
  expect_equal(
    output_16333,
    list(
      " ",
      "## Testing 'v_1'                                                            ####",
      "## Initially generated by xpectr",
      "xpectr::set_test_seed(42)",
      "# Testing class",
      "expect_equal(\n  class(v_1),\n  \"numeric\",\n  fixed = TRUE)",
      "# Testing type",
      "expect_type(\n  v_1,\n  type = \"double\")",
      "# Testing values",
      paste0("expect_equal(\n  v_1,\n  c(0.2655086631421, 0.3721238996367",
             "9, 0.572853363351896, 0.908207789994776, \n    0.201681931037456,",
             " 0.898389684967697, 0.944675268605351, 0.660797792486846, \n    0",
             ".62911404389888, 0.0617862704675645, 0.205974574899301, 0.17",
             "6556752528995, \n    0.687022846657783, 0.384103718213737, 0.7698",
             "41419998556, 0.497699242085218, \n    0.717618508264422, 0.991906",
             "094830483, 0.380035179434344, 0.777445221319795),\n  toleran",
             "ce = 1e-6)"),
      "# Testing names",
      "expect_equal(\n  names(v_1),\n  NULL,\n  fixed = TRUE)",
      "# Testing length",
      "expect_equal(\n  length(v_1),\n  20L)",
      "# Testing sum of element lengths",
      "expect_equal(\n  sum(xpectr::element_lengths(v_1)),\n  20L)",
      "## Finished testing 'v_1'                                                   ####",
      " "
    ))
  # Testing names
  expect_equal(
    names(output_16333),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_16333),
    18L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_16333)),
    18L)
  ## Finished testing 'gxs_selection("v_1", tolerance = "1e-6", rou...'     ####

})

test_that("side effect expectations are created properly with gxs_selection()", {

  set_test_seed(1)

  fn <- function(raise = FALSE, have_output = TRUE){
    random_number <-  round(runif(1), digits = 4)
    message(paste0("Hi! I'm Kevin, your favorite message!", random_number))
    warning(paste0("G'Day Mam! I'm a warning to the world!", random_number))
    message(paste0("Kevin is ma name! Yesss!", random_number))
    warning(paste0("Hopefully the whole world will see me :o", random_number))
    if (isTRUE(raise)){
      stop(paste0("Lord Evil Error has arrived! Yeehaaa", random_number))
    }
    if (isTRUE(have_output))
      return("the output")
  }

  set_test_seed(1)

  ## Testing 'fn()'                                                         ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12655 <- xpectr::capture_side_effects(fn())
  expect_equal(
    xpectr::strip(side_effects_12655[['warnings']]),
    xpectr::strip(c("G'Day Mam! I'm a warning to the world!0.9148",
          "Hopefully the whole world will see me :o0.9148")),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12655[['messages']]),
    xpectr::strip(c("Hi! I'm Kevin, your favorite message!0.9148\n",
          "Kevin is ma name! Yesss!0.9148\n")),
    fixed = TRUE)
  # Assigning output
  output_12655 <- xpectr::suppress_mw(fn())
  # Testing class
  expect_equal(
    class(output_12655),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12655,
    type = "character")
  # Testing values
  expect_equal(
    output_12655,
    "the output",
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_12655),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12655),
    1L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12655)),
    1L)
  ## Finished testing 'fn()'                                                ####

  set_test_seed(1)

  ## Testing 'fn(raise = TRUE)'                                             ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  expect_error(
    xpectr::strip_msg(fn(raise = TRUE)),
    xpectr::strip("Lord Evil Error has arrived! Yeehaaa0.9148"),
    fixed = TRUE)
  ## Finished testing 'fn(raise = TRUE)'                                    ####

  set_test_seed(1)
  ## Testing 'fn(have_output = FALSE)'                                      ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12655 <- xpectr::capture_side_effects(fn(have_output = FALSE))
  expect_equal(
    xpectr::strip(side_effects_12655[['warnings']]),
    xpectr::strip(c("G'Day Mam! I'm a warning to the world!0.9148",
          "Hopefully the whole world will see me :o0.9148")),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12655[['messages']]),
    xpectr::strip(c("Hi! I'm Kevin, your favorite message!0.9148\n",
          "Kevin is ma name! Yesss!0.9148\n")),
    fixed = TRUE)
  # Testing is NULL
  expect_true(
    is.null(xpectr::suppress_mw(fn(have_output = FALSE))))
  ## Finished testing 'fn(have_output = FALSE)'                             ####

  # In case a warning or message is the last thing in the function
  # it's string will be returned. We don't want to test that,
  # so if the returned is in the side effect strings,
  # we don't make other tests!

  fn_2 <- function(){
    message("hey")
    warning("this is a warning AND the invisible output")
  }

  set_test_seed(31)

  ## Testing 'fn_2()'                                                       ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15221 <- xpectr::capture_side_effects(fn_2())
  expect_equal(
    xpectr::strip(side_effects_15221[['warnings']]),
    xpectr::strip("this is a warning AND the invisible output"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15221[['messages']]),
    xpectr::strip("hey\n"),
    fixed = TRUE)
  ## Finished testing 'fn_2()'                                              ####

})
