% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/element_descriptors.R
\name{element_lengths}
\alias{element_lengths}
\title{Gets the length of each element}
\usage{
element_lengths(x, keep_names = FALSE)
}
\arguments{
\item{x}{List with elements.}

\item{keep_names}{Whether to keep existing names. (Logical)}
}
\value{
The length of each element.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

Applies \code{\link[base:length]{length()}} to each element of \code{`x`} (without recursion).
}
\details{
Simple wrapper for \code{unlist(lapply(x, length))}.
}
\examples{
# Attach packages
library(xpectr)

l <- list("a" = c(1,2,3), "b" = 1, "c" = NULL)

element_lengths(l)
element_lengths(l, keep_names = TRUE)
}
\seealso{
Other element descriptors: 
\code{\link{element_classes}()},
\code{\link{element_types}()},
\code{\link{num_total_elements}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{element descriptors}
