% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnn.imp.R
\name{pnn.imp}
\alias{pnn.imp}
\title{Derive the importance rank of all predictors used in the PNN}
\usage{
pnn.imp(net)
}
\arguments{
\item{net}{A PNN object generated by pnn.fit()}
}
\value{
A dataframe with important values of all predictors in the PNN
}
\description{
The function \code{pnn.imp} derives the importance rank of all predictors used in the PNN
It essentially is a wrapper around the function \code{pnn.x_imp}.
}
\examples{
data(iris, package = "datasets")
Y <- iris[, 5]
X <- scale(iris[, 1:4])
pnet <- pnn.fit(x = X, y = Y)
\donttest{
pnn.imp(pnet)
}
}
\seealso{
\code{\link{pnn.x_imp}}
}
