% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnn.x_imp.R
\name{pnn.x_imp}
\alias{pnn.x_imp}
\title{Derive the importance of a predictor used in the PNN}
\usage{
pnn.x_imp(net, i)
}
\arguments{
\item{net}{A PNN object generated by pnn.fit()}

\item{i}{The ith predictor in the PNN}
}
\value{
A vector with the variable name and two values of importance measurements, namely "imp1" and "imp2".
        The "imp1" measures the increase in cross entropy after replacing all values of the predictor with its mean.
        The "imp2" measures the increase in cross entropy after dropping the predictor from the PNN.
}
\description{
The function \code{pnn.x_imp} derives the importance of a predictor used in the PNN,
where the "importance" is measured by the increase in cross entropy after eliminating the impact 
of the predictor in interest.
}
\examples{
data(iris, package = "datasets")
Y <- iris[, 5]
X <- scale(iris[, 1:4])
pnet <- pnn.fit(x = X, y = Y)
pnn.x_imp(pnet, 1)
}
\seealso{
\code{\link{pnn.x_pfi}}
}
