% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrometheeS4.R
\docType{class}
\name{RPrometheeArguments-class}
\alias{RPrometheeArguments-class}
\title{An S4 class to be used by all RPromethee methods.}
\description{
An S4 class to be used by all RPromethee methods.
}
\section{Slots}{

\describe{
\item{\code{datMat}}{A matrix containing the data from criterias and alternatives.}

\item{\code{vecWeights}}{A vector of weights for each criteria.}

\item{\code{vecMaximiz}}{A logical vector to indicate if the criteria should be
maximized or minimized.}

\item{\code{prefFunction}}{A numerical vector to indicate the type of the Preference
Function}

\item{\code{parms}}{a numerical matrix with parameters associated to the Preference
Function. They're defined as a matrix of n columns and m rows. The maximum
number of parameters is 3 and m is the number of criterias.}

\item{\code{normalize}}{A boolean to normalize the index.}

\item{\code{alphaVector}}{A numerical vector to indicate the size of the interval for
each alternative in Promethee III ranking.}

\item{\code{band}}{A numerical matrix with m rows corresponding to each criteria and
one column corresponding to the bandwitch estimated for that criteria.}

\item{\code{constraintDir}}{A character vector with the direction of constraints to
be optimized in Promethee V.}

\item{\code{bounds}}{A numeric vector used in Promethee V for the right-hand sides of
the constraints.}

\item{\code{alternatives}}{A character vector with alternatives names.}

\item{\code{criterias}}{A character vector with criterias names.}
}}

