% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfdates.R
\name{cfdates}
\alias{cfdates}
\title{Create Date Squence}
\usage{
cfdates(sdates,edates,snapshots)
}
\arguments{
\item{sdates}{start date in Matlab datenum format.}

\item{edates}{end date in Matlab datenum format.}

\item{snapshots}{Integer indicating the number of credit-rating snapshots per year to be considered for the estimation.
Valid values are 1, 4, 12, 54, and 356.
For example, 1 = one snapshot per year}
}
\value{
a list containing a date sequence.
}
\description{
This function takes two dates and returns a sequence of dates using the interval.
}
\examples{
# Convert a date string to Matlab datenum format.
sdates <-  POSIXTomatlab(as.POSIXlt(as.Date("2000-01-01")))
edates <-  POSIXTomatlab(as.POSIXlt(as.Date("2002-01-01")))

cfdates(sdates, edates, 1)


}
\author{
Abdoulaye (Ab) N'Diaye
}
