% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bs-dependencies.R
\name{bs_theme_dependencies}
\alias{bs_theme_dependencies}
\title{Compile Bootstrap Sass with (optional) theming}
\usage{
bs_theme_dependencies(
  theme,
  sass_options = sass::sass_options(output_style = "compressed"),
  cache = sass::sass_cache_get(),
  jquery = jquerylib::jquery_core(3),
  precompiled = get_precompiled_option("bslib.precompiled", default = TRUE)
)
}
\arguments{
\item{theme}{a \code{\link[=bs_theme]{bs_theme()}} object.}

\item{sass_options}{a \code{\link[sass:sass_options]{sass::sass_options()}} object.}

\item{cache}{This can be a directory to use for the cache, a \link[sass]{FileCache}
object created by \code{\link[sass:sass_file_cache]{sass_file_cache()}}, or \code{FALSE} or \code{NULL} for no caching.}

\item{jquery}{a \code{\link[jquerylib:jquery_core]{jquerylib::jquery_core()}} object.}

\item{precompiled}{Before compiling the theme object, first look for a
precompiled CSS file for the \code{\link[=theme_version]{theme_version()}}.  If \code{precompiled = TRUE}
and a precompiled CSS file exists for the theme object, it will be fetched
immediately and not compiled. At the moment, we only provide precompiled
CSS for "stock" builds of Bootstrap (i.e., no theming additions, bootswatch
themes, or non-default \code{sass_options}).}
}
\value{
a list of HTML dependencies containing Bootstrap CSS, Bootstrap
JavaScript, and \code{jquery}. This list may contain additional HTML
dependencies if bundled with the \code{theme}.
}
\description{
\code{bs_theme_dependencies()} compiles Bootstrap Sass into CSS and returns it,
along with other HTML dependencies, as a list of
\code{\link[htmltools:htmlDependency]{htmltools::htmlDependency()}}s. Most users won't need to call this function
directly as Shiny & R Markdown will perform this compilation automatically
when handed a \code{\link[=bs_theme]{bs_theme()}}. If you're here looking to create a themeable
component, see \code{\link[=bs_dependency]{bs_dependency()}}.
}
\section{Sass caching and precompilation}{


If Shiny Developer Mode is enabled (by setting \code{options(shiny.devmode = TRUE)} or calling \code{shiny::devmode(TRUE)}), both \pkg{sass} caching and \pkg{bslib}
precompilation are disabled by default; that is, a call to
\code{bs_theme_dependencies(theme)} expands to \code{bs_theme_dependencies(theme, cache = F, precompiled = F)}). This is useful for local development as
enabling caching/precompilation may produce incorrect results if local
changes are made to bslib's source files.
}

\examples{

# Function to preview the styling a (primary) Bootstrap button
library(htmltools)
button <- tags$a(class = "btn btn-primary", href = "#", role = "button", "Hello")
preview_button <- function(theme) {
  if (interactive()) {
    browsable(tags$body(bs_theme_dependencies(theme), button))
  }
}

# Latest Bootstrap
preview_button(bs_theme())
# Bootstrap 3
preview_button(bs_theme(3))
# Bootswatch 4 minty theme
preview_button(bs_theme(4, bootswatch = "minty"))
# Bootswatch 4 sketchy theme
preview_button(bs_theme(4, bootswatch = "sketchy"))

}
\seealso{
\code{\link[=bs_theme]{bs_theme()}}, \code{\link[=bs_dependency]{bs_dependency()}}
}
