% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/push.R
\name{push}
\alias{push}
\title{Insert an object into a stack}
\usage{
push(.stack, x)
}
\arguments{
\item{.stack}{A stack.}

\item{x}{An object to insert in \code{.stack}.}
}
\value{
\code{NULL} is returned invisibly.
}
\description{
The \code{push} function inserts an 
object into \code{.stack}.
}
\details{
The \code{push} function is not pure. Side effects (made on purpose) are: 
\itemize{
  \item \code{.stack} is modified in the calling environment; 
  \item \code{x} is removed (deleted) if it exists in the calling environment. 
}
}
\examples{
(s <- lifo(max_length = 3)) # empty LIFO
(push(s, 0.3)) #
(push(s, data.frame(x=1:2, y=2:3))) 
obj <- pop(s) # get the last element inserted

}
\seealso{
\code{\link[flifo]{pop}}.
}

