% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kntn_auth.R
\name{kntn_auth}
\alias{kntn_auth}
\alias{kntn_get_authorization_header}
\alias{kntn_set_auth}
\alias{kntn_unset_auth}
\title{Authorization Header for 'kintone'}
\usage{
kntn_get_authorization_header()

kntn_set_auth(auth_type = c("password", "token"), overwrite = FALSE)

kntn_unset_auth()
}
\arguments{
\item{auth_type}{Type of Authentication. \code{password} uses username and password.
\code{token} uses per-app token.}

\item{overwrite}{If \code{TRUE}, overwrite the existing environmental variables.}
}
\description{
\code{kntn_get_authorization_header()} constructs a header for authorization using \link[httr]{add_headers}.
\code{kntn_set_auth()} interactivery asks for the type of authentication and the credential and store
them as environmental variables \code{KNTN_URL}, \code{KNTN_AUTH_TYPE} and \code{KNTN_AUTH}.
If you want to avoid interaction, please manually set these.
\code{kntn_unset_auth()} unsets these environmental variables.
}
\examples{
\dontrun{
# set KNTN_URL, KNTN_AUTH and KNTN_AUTH_TYPE interactively.
# By default, auth_type is password.
kntn_set_auth()

Sys.getenv(c("KNTN_URL", "KNTN_AUTH", "KNTN_AUTH_TYPE"))

# This will return `X-Cybozu-Authorization` header.
kntn_get_authorization_header()

# Clear environmental variables before trying to use another set of authorization info.
kntn_unset_auth()
kntn_set_auth(auth_type = "token")

# This will return `X-Cybozu-API-Token` header.
kntn_get_authorization_header()

# To avoid interaction, set these environmental variables manually.
Sys.setenv("KNTN_URL" = "https://example.cybozu.com/")
Sys.setenv("KNTN_AUTH" = "abcdefg")
Sys.setenv("KNTN_AUTH_TYPE" = "token")
}
}
\seealso{
\url{https://developer.kintone.io/hc/en-us/articles/212495188/#userauthentication}
}

