% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneDrop.R
\name{geneDrop}
\alias{geneDrop}
\alias{geneDrop.default}
\alias{geneDrop.numPed}
\title{Functions to conduct gene dropping through a pedigree}
\usage{
geneDrop(
  pedigree,
  N,
  parallel = FALSE,
  ncores = getOption("mc.cores", 2L),
  ...
)

\method{geneDrop}{default}(
  pedigree,
  N,
  parallel = FALSE,
  ncores = getOption("mc.cores", 2L),
  ...
)

\method{geneDrop}{numPed}(
  pedigree,
  N,
  parallel = FALSE,
  ncores = getOption("mc.cores", 2L),
  ...
)
}
\arguments{
\item{pedigree}{A pedigree with columns organized: ID, Dam, Sire.}

\item{N}{The number of times to iteratively trace alleles through the
pedigree}

\item{parallel}{A logical indicating whether or not to use parallel
processing. Note, this may only be available for Mac and Linux operating
systems.}

\item{ncores}{The number of cpus to use when constructing the dominance
relatedness matrix. Default is all available.}

\item{\dots}{Other arguments that can be supplied to alter what summaries are
reported.}
}
\value{
a \code{list}:
  \describe{
    \item{IDs }{Original identities in the pedigree}
    \item{maternal }{Simulated maternal haplotypes}
    \item{paternal }{Simulated paternal haplotypes} 
    \item{numericPedigree }{Pedigree in class \code{numPed} for convenient
      post-processing of haplotypes}
  }
}
\description{
Functions that perform and summarize gene dropping conducted on supplied pedigrees
}
\details{
Missing parents (e.g., base population) should be denoted by either 'NA', '0'
, or '*'.

\code{parallel} = TRUE should only be used on Linux or Mac operating systems
(i.e., not Windows).

Founder allelic values (the alleles assigned to an individual's maternal,
paternal, or both haplotypes when the maternal, paternal, or both parents are
missing) are equivalent positive and negative integer values corresponding to
the maternal and paternal haplotypes, respectively. For example, if the first
individual in the pedigree has two unknown parents it will have the following
two allelic values: 1=maternal haplotype and -1=paternal haplotype.
}
\examples{
  geneDrop(Mrode2, N = 10)

}
\seealso{
\code{\link{makeDsim}}
}
\author{
\email{matthewwolak@gmail.com}
}
