% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rSARP.r
\name{SearchInput.csv}
\alias{SearchInput.csv}
\title{SearchInput.csv - typical Data input file for \pkg{rSARP}}
\format{A data frame with 32 rows and 15 variables}
\source{
John Hutcheson
}
\description{
A dataset containing the sectors or search areas and key attributes of each
that will be searched. This file is stored in the working directory of R and
must be named SearchInput.csv. The variables described in the file are as follows:
}
\details{
\itemize{
  \item Sector. Name of the sector or grid to be searched.  Usually Alpha characters excluding I and O.
  \item Area. Area of the sector to be searched in Hectares or Acres.  Defaults to Hectares and requires parametric change in call to \code{searchme()} if Acres is used.
  \item AreaCoverage. Percentage of the the sector Area that was or will be covered. Typically used if the search teams are unable to
cover the entire sector due to unforeseen hazards in the sector. If the value given is negative, then it signifies that portion of the area is being
searched for the first time, bypassing bayesian treatments, even if the sector has a POScum value (indicating the a portion of the sector was
previously searched.
  \item Terrain. Keyword describing the terrain of the sector which can be used to provide the expected speed of travel and estimated AMDR.
Currently limited to use of a set of keywords. Use HeavyWoods, OpenWoods, OpenArea, SteepTerrain, ModerateTerrain, FlatArea, Urban. See guide for further specifics.
  \item TOD. Time of Day.  Keyword describing time of search and currently limited to Day or Night.
  \item WX. Weather keyword describing conditions during the search.  Currently limited to Normal or Snow6to8in.
  \item THours. Target duration Hours.  Hours team will be deployed for the search in the field not counting breaks or transportation time.
        If -1 entered for this value program will optimize using internal algorithms.
  \item TSearchers. Target Searchers.  Count of searchers, excluding non-searching supervisors, in the field assigned to that sector.
        If -1 entered for this value program will optimize using internal algorithms.
  \item TSpacing. Target Spacing.  The distance in meters between searchers planned for this sector search.
         If -1 entered for this value program will optimize using internal algorithms.
  \item AMDR. Average Maximum Detection Range in meters.  Initially estimated, then updated as measured AMDRs are reported in.
         If -1 entered for this value program will estimate based on Terrain values
  \item Rank. Total rank of the sector from sector ladder ranking exercise.  Use raw score totals - software will normalize and handle appropriately.
  \item POScum. Cumulative Probability of Success for the sector in percentage points. Represents the POS that has already been 'harvested'
for that area.  If entered as negative number, will revise reports to indicate that no further searching is planned for this sector.
  \item TerrainWords. Listing of the key words which can be used in Terrain values.
  \item TODWords. Listing of the key words which can be used in TOD values.
  \item WXWords.  Listing of the key words which can be used in WX values.
}
}

