/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Set;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyInstance;
import org.python.core.PyMethod;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.core.PyString;
import org.python.core.ReflectedArgs;
import org.python.core.ReflectedCallData;
import org.python.util.Generic;

public class PyReflectedFunction
extends PyObject {
    public String __name__;
    public PyObject __doc__ = Py.None;
    public ReflectedArgs[] argslist;
    public int nargs;

    public PyReflectedFunction(String name) {
        this.__name__ = name;
        this.argslist = new ReflectedArgs[1];
        this.nargs = 0;
    }

    public PyReflectedFunction(Method method) {
        this(method.getName());
        this.addMethod(method);
    }

    public PyObject _doget(PyObject container) {
        return this._doget(container, null);
    }

    public PyObject _doget(PyObject container, PyObject wherefound) {
        if (container == null) {
            return this;
        }
        return new PyMethod(this, container, wherefound);
    }

    public boolean _doset(PyObject container) {
        throw Py.TypeError("java function not settable: " + this.__name__);
    }

    public PyObject getDoc() {
        return this.__doc__;
    }

    private ReflectedArgs makeArgs(Method m) {
        return new ReflectedArgs(m, m.getParameterTypes(), m.getDeclaringClass(), Modifier.isStatic(m.getModifiers()));
    }

    public PyReflectedFunction copy() {
        PyReflectedFunction func = new PyReflectedFunction(this.__name__);
        func.__doc__ = this.__doc__;
        func.nargs = this.nargs;
        func.argslist = new ReflectedArgs[this.nargs];
        System.arraycopy(this.argslist, 0, func.argslist, 0, this.nargs);
        return func;
    }

    public boolean handles(Method method) {
        return this.handles(this.makeArgs(method));
    }

    protected boolean handles(ReflectedArgs args) {
        ReflectedArgs[] argsl = this.argslist;
        int n = this.nargs;
        for (int i = 0; i < n; ++i) {
            int cmp = args.compareTo(argsl[i]);
            if (cmp == 0) {
                return true;
            }
            if (cmp != 1) continue;
            return false;
        }
        return false;
    }

    public void addMethod(Method m) {
        int mods = m.getModifiers();
        if (!Modifier.isPublic(mods) && Options.respectJavaAccessibility) {
            return;
        }
        this.addArgs(this.makeArgs(m));
    }

    protected void addArgs(ReflectedArgs args) {
        int nn;
        int i;
        ReflectedArgs[] argsl = this.argslist;
        int n = this.nargs;
        for (i = 0; i < n; ++i) {
            int cmp = args.compareTo(argsl[i]);
            if (cmp == 0) {
                return;
            }
            if (cmp == 1998) {
                argsl[i] = args;
                return;
            }
            if (cmp == -1) break;
        }
        if ((nn = n + 1) > argsl.length) {
            argsl = new ReflectedArgs[nn + 2];
            System.arraycopy(this.argslist, 0, argsl, 0, n);
            this.argslist = argsl;
        }
        for (int j = n; j > i; --j) {
            argsl[j] = argsl[j - 1];
        }
        argsl[i] = args;
        this.nargs = nn;
    }

    public PyObject __call__(PyObject self, PyObject[] args, String[] keywords) {
        ReflectedCallData callData = new ReflectedCallData();
        Object method = null;
        ReflectedArgs[] argsl = this.argslist;
        int n = this.nargs;
        for (int i = 0; i < n; ++i) {
            ReflectedArgs rargs = argsl[i];
            if (!rargs.matches(self, args, keywords, callData)) continue;
            method = rargs.data;
            break;
        }
        if (method == null) {
            this.throwError(callData.errArg, args.length, self != null, keywords.length != 0);
        }
        Object cself = callData.self;
        Method m = (Method)method;
        if (self == null && cself != null && cself instanceof PyProxy && !this.__name__.startsWith("super__")) {
            String mname;
            Method[] super__methods;
            PyInstance iself = ((PyProxy)cself)._getPyInstance();
            if (this.argslist[0].declaringClass != iself.instclass.proxyClass && (super__methods = (Method[])iself.instclass.super__methods.get(mname = "super__" + this.__name__)) != null) {
                Object[] msig = m.getParameterTypes();
                for (Method super__method : super__methods) {
                    if (!Arrays.equals(msig, super__method.getParameterTypes())) continue;
                    m = super__method;
                    break;
                }
            }
        }
        try {
            Object o = m.invoke(cself, callData.getArgsArray());
            return Py.java2py(o);
        }
        catch (Throwable t) {
            throw Py.JavaError(t);
        }
    }

    public PyObject __call__(PyObject[] args, String[] keywords) {
        return this.__call__(null, args, keywords);
    }

    protected void throwError(String message) {
        throw Py.TypeError(this.__name__ + "(): " + message);
    }

    private static void addRange(StringBuffer buf, int min, int max, String sep) {
        if (buf.length() > 0) {
            buf.append(sep);
        }
        if (min < max) {
            buf.append(Integer.toString(min) + "-" + max);
        } else {
            buf.append(min);
        }
    }

    protected void throwArgCountError(int nArgs, boolean self) {
        boolean[] legalArgs = new boolean[40];
        int maxArgs = -1;
        int minArgs = 40;
        ReflectedArgs[] argsl = this.argslist;
        int n = this.nargs;
        for (int i = 0; i < n; ++i) {
            ReflectedArgs rargs = argsl[i];
            int l = rargs.args.length;
            if (!self && !rargs.isStatic) {
                ++l;
            }
            legalArgs[l] = true;
            if (l > maxArgs) {
                maxArgs = l;
            }
            if (l >= minArgs) continue;
            minArgs = l;
        }
        StringBuffer buf = new StringBuffer();
        int startRange = minArgs;
        int a = minArgs + 1;
        block1: while (a < maxArgs) {
            if (legalArgs[a]) {
                ++a;
                continue;
            }
            PyReflectedFunction.addRange(buf, startRange, a - 1, ", ");
            ++a;
            while (a <= maxArgs) {
                if (legalArgs[a]) {
                    startRange = a;
                    continue block1;
                }
                ++a;
            }
        }
        PyReflectedFunction.addRange(buf, startRange, maxArgs, " or ");
        this.throwError("expected " + buf + " args; got " + nArgs);
    }

    private static String ordinal(int n) {
        switch (n + 1) {
            case 0: {
                return "self";
            }
            case 1: {
                return "1st";
            }
            case 2: {
                return "2nd";
            }
            case 3: {
                return "3rd";
            }
        }
        return Integer.toString(n + 1) + "th";
    }

    private static String niceName(Class arg) {
        if (arg == String.class || arg == PyString.class) {
            return "String";
        }
        if (arg.isArray()) {
            return PyReflectedFunction.niceName(arg.getComponentType()) + "[]";
        }
        return arg.getName();
    }

    protected void throwBadArgError(int errArg, int nArgs, boolean self) {
        Set<Class> argTypes = Generic.set();
        for (int i = 0; i < this.nargs; ++i) {
            if (this.argslist[i].args.length != nArgs) continue;
            if (errArg == -1) {
                argTypes.add(this.argslist[i].declaringClass);
                continue;
            }
            argTypes.add(this.argslist[i].args[errArg]);
        }
        StringBuilder buf = new StringBuilder();
        for (Class arg : argTypes) {
            buf.append(PyReflectedFunction.niceName(arg));
            buf.append(", ");
        }
        if (buf.length() > 2) {
            buf.setLength(buf.length() - 2);
        }
        this.throwError(PyReflectedFunction.ordinal(errArg) + " arg can't be coerced to " + buf);
    }

    protected void throwError(int errArg, int nArgs, boolean self, boolean keywords) {
        if (keywords) {
            this.throwError("takes no keyword arguments");
        } else if (errArg == -2) {
            this.throwArgCountError(nArgs, self);
        } else {
            this.throwBadArgError(errArg, nArgs, self);
        }
    }

    public void printArgs() {
        System.err.println("nargs: " + this.nargs);
        for (int i = 0; i < this.nargs; ++i) {
            ReflectedArgs args = this.argslist[i];
            System.err.println(args.toString());
        }
    }

    public String toString() {
        return "<java function " + this.__name__ + " " + Py.idstr(this) + ">";
    }
}

