/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.nio.ByteBuffer;
import java.util.regex.Pattern;
import org.python.core.io.BinaryIOWrapper;
import org.python.core.io.BufferedIOBase;

public class TextIOWrapper
extends BinaryIOWrapper {
    private static final Pattern LF_PATTERN = Pattern.compile("\n");
    private String newline = System.getProperty("line.separator");
    private boolean newlineIsLF = this.newline.equals("\n");

    public TextIOWrapper(BufferedIOBase bufferedIO) {
        super(bufferedIO);
    }

    public String read(int size) {
        int readaheadPos;
        if (this.newlineIsLF) {
            return super.read(size);
        }
        if (size < 0) {
            return this.readall();
        }
        char[] builderArray = new char[size];
        int builderPos = 0;
        do {
            byte[] readaheadArray = this.readahead.array();
            readaheadPos = this.readahead.position();
            while (readaheadPos < this.readahead.limit() && builderPos < size) {
                int next;
                if ((next = (int)(readaheadArray[readaheadPos++] & 0xFF)) == 13) {
                    if (readaheadPos == this.readahead.limit()) {
                        if (this.readChunk() == 0) {
                            builderArray[builderPos++] = next;
                            return new String(builderArray, 0, builderPos);
                        }
                        readaheadArray = this.readahead.array();
                        readaheadPos = this.readahead.position();
                    }
                    if (readaheadArray[readaheadPos] == 10) {
                        next = 10;
                        ++readaheadPos;
                    }
                }
                builderArray[builderPos++] = next;
            }
        } while (builderPos < size && this.readChunk(size - builderPos) > 0);
        if (this.readahead.hasRemaining()) {
            this.readahead.position(readaheadPos);
        }
        this.packReadahead();
        return new String(builderArray, 0, builderPos);
    }

    public String readall() {
        if (this.newlineIsLF) {
            return super.readall();
        }
        ByteBuffer remaining = this.bufferedIO.readall();
        int length = 0;
        if (this.readahead.hasRemaining() && this.readahead.get(this.readahead.limit() - 1) == 13 && remaining.hasRemaining() && remaining.get(remaining.position()) == 10) {
            --length;
        }
        char[] all = new char[this.readahead.remaining() + remaining.remaining()];
        length += this.readLoop(this.readahead.array(), this.readahead.position(), all, 0, this.readahead.remaining());
        this.readahead.position(this.readahead.limit());
        length += this.readLoop(remaining.array(), remaining.position(), all, length, remaining.remaining());
        return new String(all, 0, length);
    }

    private int readLoop(byte[] src, int srcPos, char[] dest, int destPos, int length) {
        int destStartPos = destPos;
        int srcEndPos = srcPos + length;
        while (srcPos < srcEndPos) {
            int next;
            if ((next = (int)(src[srcPos++] & 0xFF)) == 13) {
                if (srcPos == srcEndPos) {
                    dest[destPos++] = next;
                    continue;
                }
                if (src[srcPos] == 10) {
                    next = 10;
                    ++srcPos;
                }
            }
            dest[destPos++] = next;
        }
        return destPos - destStartPos;
    }

    public String readline(int size) {
        int readaheadPos;
        if (this.newlineIsLF) {
            return super.readline(size);
        }
        do {
            byte[] readaheadArray = this.readahead.array();
            readaheadPos = this.readahead.position();
            int interimBuilderPos = 0;
            while (readaheadPos < this.readahead.limit() && (size < 0 || this.builder.length() + interimBuilderPos < size)) {
                int next = readaheadArray[readaheadPos++] & 0xFF;
                this.interimBuilder[interimBuilderPos++] = next;
                if (next == 13) {
                    boolean flushInterimBuilder = false;
                    if (readaheadPos == this.readahead.limit()) {
                        if (this.readChunk() == 0) {
                            this.builder.append(this.interimBuilder, 0, interimBuilderPos);
                            return this.drainBuilder();
                        }
                        readaheadArray = this.readahead.array();
                        readaheadPos = this.readahead.position();
                        flushInterimBuilder = true;
                    }
                    if (readaheadArray[readaheadPos] == 10) {
                        ++readaheadPos;
                        next = 10;
                        this.interimBuilder[interimBuilderPos - 1] = 10;
                    }
                    if (flushInterimBuilder) {
                        this.builder.append(this.interimBuilder, 0, interimBuilderPos);
                        interimBuilderPos = 0;
                    }
                }
                if (next != 10) continue;
                this.builder.append(this.interimBuilder, 0, interimBuilderPos);
                this.readahead.position(readaheadPos);
                return this.drainBuilder();
            }
            this.builder.append(this.interimBuilder, 0, interimBuilderPos);
        } while ((size < 0 || this.builder.length() < size) && this.readChunk() > 0);
        if (this.readahead.hasRemaining()) {
            this.readahead.position(readaheadPos);
        }
        return this.drainBuilder();
    }

    public int write(String buf) {
        if (!this.newlineIsLF) {
            buf = LF_PATTERN.matcher(buf).replaceAll(this.newline);
        }
        return super.write(buf);
    }
}

