/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules._weakref;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.modules._weakref.AbstractReference;

public class GlobalRef
extends WeakReference {
    int hash;
    boolean realHash;
    private Vector references = new Vector();
    private static ReferenceQueue referenceQueue = new ReferenceQueue();
    private static RefReaperThread reaperThread;
    private static Map objects;

    public GlobalRef(PyObject object) {
        super(object, referenceQueue);
        this.calcHash(object);
    }

    private void calcHash(PyObject object) {
        try {
            this.hash = object.hashCode();
            this.realHash = true;
        }
        catch (PyException pye) {
            if (Py.matchException(pye, Py.TypeError)) {
                this.hash = System.identityHashCode(object);
            }
            throw pye;
        }
    }

    public synchronized void add(AbstractReference ref) {
        WeakReference<AbstractReference> r = new WeakReference<AbstractReference>(ref);
        this.references.addElement(r);
    }

    private final AbstractReference getReferenceAt(int idx) {
        WeakReference wref = (WeakReference)this.references.elementAt(idx);
        return (AbstractReference)wref.get();
    }

    synchronized AbstractReference find(Class cls) {
        for (int i = this.references.size() - 1; i >= 0; --i) {
            AbstractReference r = this.getReferenceAt(i);
            if (r == null) {
                this.references.removeElementAt(i);
                continue;
            }
            if (r.callback != null || r.getClass() != cls) continue;
            return r;
        }
        return null;
    }

    synchronized void call() {
        for (int i = this.references.size() - 1; i >= 0; --i) {
            AbstractReference r = this.getReferenceAt(i);
            if (r == null) {
                this.references.removeElementAt(i);
                continue;
            }
            r.call();
        }
    }

    public synchronized int count() {
        for (int i = this.references.size() - 1; i >= 0; --i) {
            AbstractReference r = this.getReferenceAt(i);
            if (r != null) continue;
            this.references.removeElementAt(i);
        }
        return this.references.size();
    }

    public synchronized PyList refs() {
        Vector<AbstractReference> list = new Vector<AbstractReference>();
        for (int i = this.references.size() - 1; i >= 0; --i) {
            AbstractReference r = this.getReferenceAt(i);
            if (r == null) {
                this.references.removeElementAt(i);
                continue;
            }
            list.addElement(r);
        }
        return new PyList(list);
    }

    public static GlobalRef newInstance(PyObject object) {
        GlobalRef ref = (GlobalRef)objects.get(new GlobalRef(object));
        if (ref == null) {
            ref = new GlobalRef(object);
            objects.put(ref, ref);
        }
        return ref;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GlobalRef)) {
            return false;
        }
        Object t = this.get();
        Object u = ((GlobalRef)o).get();
        if (t == null || u == null) {
            return false;
        }
        if (t == u) {
            return true;
        }
        return t.equals(u);
    }

    public int hashCode() {
        return this.hash;
    }

    private static void initReaperThread() {
        reaperThread = new RefReaperThread();
        reaperThread.setDaemon(true);
        reaperThread.start();
    }

    static {
        objects = new HashMap();
        GlobalRef.initReaperThread();
    }

    private static class RefReaperThread
    extends Thread {
        RefReaperThread() {
            super("weakref reaper");
        }

        public void collect() throws InterruptedException {
            GlobalRef gr = (GlobalRef)referenceQueue.remove();
            gr.call();
            objects.remove(gr);
            gr = null;
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.collect();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

