/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.util.List;
import org.python.antlr.ParseException;
import org.python.antlr.ast.Expr;
import org.python.antlr.ast.ImportFrom;
import org.python.antlr.ast.Interactive;
import org.python.antlr.ast.Module;
import org.python.antlr.ast.Str;
import org.python.antlr.base.mod;
import org.python.antlr.base.stmt;
import org.python.core.CompilerFlags;

public class Future {
    private boolean division = false;
    private boolean with_statement = false;
    private boolean absolute_import = false;
    private static final String FUTURE = "__future__";

    private boolean check(ImportFrom cand) throws Exception {
        if (!cand.getInternalModule().equals(FUTURE)) {
            return false;
        }
        int n = cand.getInternalNames().size();
        if (n == 0) {
            throw new ParseException("future statement does not support import *", cand);
        }
        for (int i = 0; i < n; ++i) {
            String feature = cand.getInternalNames().get(i).getInternalName();
            if (feature.equals("nested_scopes")) continue;
            if (feature.equals("division")) {
                this.division = true;
                continue;
            }
            if (feature.equals("generators")) continue;
            if (feature.equals("with_statement")) {
                this.with_statement = true;
                continue;
            }
            if (feature.equals("absolute_import")) {
                this.absolute_import = true;
                continue;
            }
            if (feature.equals("braces")) {
                throw new ParseException("not a chance", cand);
            }
            if (feature.equals("GIL") || feature.equals("global_interpreter_lock")) {
                throw new ParseException("Never going to happen!", cand);
            }
            throw new ParseException("future feature " + feature + " is not defined", cand);
        }
        return true;
    }

    public void preprocessFutures(mod node, CompilerFlags cflags) throws Exception {
        stmt s;
        if (cflags != null) {
            this.division = cflags.division;
            this.with_statement = cflags.with_statement;
            this.absolute_import = cflags.absolute_import;
        }
        int beg = 0;
        List<stmt> suite = null;
        if (node instanceof Module) {
            suite = ((Module)node).getInternalBody();
            if (suite.size() > 0 && suite.get(0) instanceof Expr && ((Expr)suite.get(0)).getInternalValue() instanceof Str) {
                ++beg;
            }
        } else if (node instanceof Interactive) {
            suite = ((Interactive)node).getInternalBody();
        } else {
            return;
        }
        for (int i = beg; i < suite.size() && (s = suite.get(i)) instanceof ImportFrom; ++i) {
            s.from_future_checked = true;
            if (!this.check((ImportFrom)s)) break;
        }
        if (cflags != null) {
            boolean bl = cflags.division = cflags.division || this.division;
        }
        if (cflags != null) {
            boolean bl = cflags.with_statement = cflags.with_statement || this.with_statement;
        }
        if (cflags != null) {
            cflags.absolute_import = cflags.absolute_import || this.absolute_import;
        }
    }

    public static void checkFromFuture(ImportFrom node) throws Exception {
        if (node.from_future_checked) {
            return;
        }
        if (node.getInternalModule().equals(FUTURE)) {
            throw new ParseException("from __future__ imports must occur at the beginning of the file", node);
        }
        node.from_future_checked = true;
    }

    public boolean areDivisionOn() {
        return this.division;
    }

    public boolean withStatementSupported() {
        return this.with_statement;
    }

    public boolean isAbsoluteImportOn() {
        return this.absolute_import;
    }
}

