% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoReport.R
\name{makeAutoReportTab}
\alias{makeAutoReportTab}
\title{Make table of automated reports}
\usage{
makeAutoReportTab(
  session,
  namespace = character(),
  type = "subscription",
  mapOrgId = NULL,
  includeReportId = FALSE
)
}
\arguments{
\item{session}{A shiny session object}

\item{namespace}{String naming namespace. Defaults to \code{character()} in
which case no namespace will be created. When this function is used by shiny
modules namespace must be provided.}

\item{type}{Character string defining the type of auto reports to tabulate.
Must be one of \code{"subscription"}, \code{"dispatchment"} or
\code{"bulletin"}. Default value set to \code{"subscription"}.}

\item{mapOrgId}{Data frame containing the two columns 'name' and 'id'
corresponding to unique name and id of organizations. Default is NULL in
which case the ids provided in auto report data will be used. In case
mapOrgId is not NULL but no id match is found the id found in the auto
report data will also be used}

\item{includeReportId}{Logical if the unique report id should be added as
the last column in the table. FALSE by default.}
}
\value{
Matrix providing a table to be rendered in a shiny app
}
\description{
Make a table to be rendered in a shiny app providing automated reports
from a given user or registry as obtained from the shiny session
object provided.
}
\details{
Each table record (line) represents a uniquely defined automated report.
For each line two shiny action buttons are provided to allow
for editing and deleting of each entry. For applications
implementing this table observing events on these action buttons may be used
to allow users to manage automated reports by GUI. The
action buttons for editing and deleting are provided with the static input
ids \emph{edit_button} and \emph{del_button} and upon clicking the
\emph{button} part of their ids will change to the unique id of the
report. Hence, a GUI call for editing a report can be caught by
\code{shiny::observeEvent("edit_button")} and within this event the
report id is obtained by collecting the string after the double underscore,
\emph{e.g.} \code{strsplit(input$edit_button, "__")[[1]][2]}.

Optionally, report id may be provided as the last column in the table to
allow further development for registry specific purposes. Regardless, this
column should normally be hidden in the GUI.

Take a look at the
\href{https://github.com/Rapporteket/rapRegTemplate/blob/main/inst/shinyApps/app1/server.R}{example shiny server function in rapRegTemplate}
on how this function may be implemented.
}
