% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_datacodes.R
\name{show_datacodes}
\alias{show_datacodes}
\title{Produce and send to console a tibble of the data request codes and associated datasets.}
\usage{
show_datacodes(limit = 4)
}
\arguments{
\item{limit}{A numeric value used to determine the number of values returned.
Default is set to four (4) values, which returns all tibble values.}
}
\value{
A console printout of a tibble with a designated number of values set by \code{limit}.
}
\description{
`show_datacodes()` produces a tibble of the arguments used with the `get_ausdata()` function
and the associated datasets.
}
\details{
Items under *Request Codes* can be used to request and download the associated
Australian Politicians dataset.

The specifics of these are:

- `"all"` australian_politicians-all.csv.
- `"allbyparty"` australian_politicians-all-by_party.csv.
- `"mps"` australian_politicians-mps-by_division.csv.
- `"senators"` australian_politicians-senators-by_state.csv.
}
\examples{
\dontrun{
# Print out dataset request codes.
show_datacodes()

# Request "All" Australian Politicians dataset.
get_auspol("all")
}

}
\seealso{
`get_auspol()` function help.
}
