% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoSampleBernoulli.Design.R
\name{TwoSampleBernoulli.Design}
\alias{TwoSampleBernoulli.Design}
\title{Two sample Bernoulli model - Trial Design}
\usage{
TwoSampleBernoulli.Design(
  prior,
  nmin = 10,
  nmax = 200,
  p1,
  p2,
  d = 0,
  ps = 0.95,
  pf = 0.05,
  power = 0.8,
  t1error = 0.05,
  alternative = c("less", "greater"),
  seed = 202209,
  sim = 500
)
}
\arguments{
\item{prior}{A list of length 3 containing the distributional information of the prior.
The first element is a number specifying the type of prior. Options are
\enumerate{
\item DIP ;
\item Beta(a,b), where a = shape, b = scale}
The second and third elements of the list are the parameters a and b, respectively.}

\item{nmin}{The start searching total sample size for two treatment groups.}

\item{nmax}{The stop searching total sample size for two treatment groups.}

\item{p1}{The response rate of the new treatment.}

\item{p2}{The response rate of the compared treatment.}

\item{d}{The target improvement (minimal clinically meaningful difference).}

\item{ps}{The efficacy boundary (upper boundary).}

\item{pf}{The futility boundary (lower boundary).}

\item{power}{The power to achieve.}

\item{t1error}{The controlled type-I-error.}

\item{alternative}{less (lower values imply greater efficacy) or greater (larger
values imply greater efficacy).}

\item{seed}{The seed for simulations.}

\item{sim}{The number of simulations.}
}
\value{
A list of the arguments with method and computed elements
}
\description{
Calculate the minimum planned sample size under an admissible design.
The users decide the power and type-I-error, and pick the efficacy and futility boundaries.
If there are no admissible design based on controlled type-I-error, then default to output
the designs with the lowest type-I-error and at least the user-defined (e.g. 80\%) power.
}
\examples{
\donttest{
# with traditional Bayesian prior Beta(1,1)
TwoSampleBernoulli.Design(list(2,1,1), nmin = 100, nmax = 120, p1 = 0.5, p2 = 0.3, d = 0,
                   ps = 0.90, pf = 0.05, power = 0.8, t1error = 0.05, alternative = "greater",
                   seed = 202210, sim = 10)
# with DIP
TwoSampleBernoulli.Design(list(1,0,0), nmin = 100, nmax = 120, p1 = 0.5, p2 = 0.3, d = 0,
                   ps = 0.90, pf = 0.05, power = 0.8, t1error = 0.05, alternative = "greater",
                   seed = 202210, sim = 10)
}
}
