% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xy2index.R
\name{detect_seq}
\alias{detect_seq}
\title{Detects if a certain sequence is present in a matrix.}
\usage{
detect_seq(data, sequence, reps, diag = TRUE)
}
\arguments{
\item{data}{A matrix.}

\item{sequence}{The desired sequence to search for.}

\item{reps}{Number of repetitions of the sequence.}

\item{diag}{Do you want to search diagonals? Defaults to TRUE.}
}
\description{
This function allows for the detection of a particular sequence in a matrix.
}
\examples{
M = matrix(sample(c(1,2),25,replace=TRUE),5,5)
detect_seq(data = M, sequence = "2", reps = 5)
#or equivalently
detect_seq(data = M, sequence = "22222", reps = 1)
}
\keyword{detect}
\keyword{matrix}
\keyword{search}
\keyword{sequence}
\keyword{vector}

