% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CJIVE_Functions.R
\name{perm.jntrank}
\alias{perm.jntrank}
\title{Permutation Test for Joint Rank in CJIVE}
\usage{
perm.jntrank(
  dat.blocks,
  signal.ranks = NULL,
  nperms = 500,
  perc.var = 0.95,
  alpha = 0.05,
  center = TRUE
)
}
\arguments{
\item{dat.blocks}{a list of two matrices with samples along rows and features along columns, which contain data on the same n individuals/sampling units}

\item{signal.ranks}{a vector of length two which contains the rank for the signal within each data block. The rank corresponds to the number of principal
components (PCs) to be retained within each data block. If NULL, the ranks are determined by the parameter 'perc.var.' Default is NULL}

\item{nperms}{integer value indicating the number of permutations that should be performed}

\item{perc.var}{numeric value of either a scalar or of length 2: an alternative to signal.ranks that allows specification of signal ranks based on the
desired proportion of total variation to be retained in each data block.
For perc.var = p (where 0<p<1), rank is determined as the minimum number of eigenvalues whose cumulative sum is at least p*(total sum of eigenvalues).
Default is 0.95 (i.e. 95\% of total variation preserved for each data block). For p=c(p1,p2) pk is used to determine the rank of block k}

\item{alpha}{nominal type-I error rate}

\item{center}{logical (TRUE/FALSE) indicating whether data should be column-centered prior to testing. Default is TRUE}
}
\value{
The Frobenius norm of the matrix X, calculated as the sum of square entries in X
}
\description{
Conducts the permutation test for the number of joint components as described in CJIVE manuscript. Briefly, canonical correlations (CC) between principal component
             vectors of the data are obtained (PC). Then for 1:nperms, the rows of one data set are permuted and CCs between PC vectors are calculated, retaining
             the maximum CC. These maximum CCs form a null distribution against which the original CCs are tested. The number of original CCs exceeding the (1-alpha)^th
             percentile is the returned as the joint rank.
}
