% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClussCluster.R
\name{ClussCluster}
\alias{ClussCluster}
\alias{ClussCluster_Gap}
\title{Performs simultaneous detection of cell types and cell-type-specific signature genes}
\usage{
ClussCluster(x, nclust = NULL, centers = NULL, ws = NULL,
  nepoch.max = 10, theta = NULL, seed = 1, nstart = 20,
  iter.max = 50, verbose = FALSE)

ClussCluster_Gap(x, nclust = NULL, B = 20, centers = NULL,
  ws = NULL, nepoch.max = 10, theta = NULL, seed = 1,
  nstart = 20, iter.max = 50, verbose = FALSE)
}
\arguments{
\item{x}{An nxp data matrix. There are n cells and p genes.}

\item{nclust}{Number of clusters desired if the cluster centers are not provided. If both are provided, nclust must equal the number of cluster \code{centers}.}

\item{centers}{A set of initial (distinct) cluster centres if the number of clusters (\code{nclust}) is null. If both are provided, the number of cluster centres must equal \code{nclust}.}

\item{ws}{One or multiple candidate tuning parameters to be evaluated and compared. Determines the sparsity of the selected genes. Should be greater than 1.}

\item{nepoch.max}{The maximum number of epochs. In one epoch, each cell will be evaluated to determine if its label needs to be updated.}

\item{theta}{Optional argument. If provided, \code{theta} are used as the initial cluster labels of the ClussCluster algorithm; if not, K-means is performed to produce starting cluster labels.}

\item{seed}{This seed is used wherever K-means is used.}

\item{nstart}{Argument passed to \code{kmeans}. It is the number of random sets used in \code{kmeans}.}

\item{iter.max}{Argument passed to \code{kmeans}. The maximum number of iterations allowed.}

\item{verbose}{Print the updates inside every epoch? If TRUE, the updates of cluster label and the value of objective function will be printed out.}

\item{B}{Number of permutation samples.}
}
\value{
a list containing the optimal tuning parameter, \code{s}, group labels of clustering, \code{theta}, and type-specific weights of genes, \code{w}.

a list containig a vector of candidate tuning parameters, \code{ws}, the corresponding values of objective function, \code{O}, a matrix of values of objective function for each permuted data and tuning parameter, \code{O_b}, gap statistics and their one standard deviations, \code{Gap} and \code{sd.Gap}, the result given by \code{ClussCluster}, \code{run}, the tuning parameters with the largest Gap statistic and within one standard deviation of the largest Gap statistic, \code{bestw} and \code{onesd.bestw}
}
\description{
\code{ClussCluster} takes the single-cell transcriptome data and returns an object containing cell types and type-specific signature gene sets

Selects the tuning parameter in a permutation approach. The tuning parameter controls the L1 bound on w, the feature weights.
}
\details{
Takes the normalized and log transformed number of reads mapped to genes (e.g., log(RPKM+1) or log(TPM+1) where RPKM stands for Reads Per Kilobase of transcript per Million mapped reads and TPM stands for transcripts per million) but NOT centered.
}
\examples{
data(Hou_sim)
hou.dat <-Hou_sim$x
run.ft <- filter_gene(hou.dat)
hou.test <- ClussCluster(run.ft$dat.ft, nclust=3, ws=4, verbose = FALSE)
}
