% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hou_sim.dat.R
\docType{data}
\name{Hou_sim}
\alias{Hou_sim}
\title{A truncated subset of the scRNA-seq expression data set from Hou et.al (2016)}
\format{An object containing the following variables:
\describe{
\item{\code{x}}{An expression data frame of 33 HCC cells on 100 genes.}
\item{\code{y}}{Numerical group indicator of all cells.}
\item{\code{gnames}}{Gene names of all genes.}
\item{\code{snames}}{Cell names of all cells.}
\item{\code{groups}}{Cell group names.}
\item{\code{note}}{A simple note of the data set.}
}}
\source{
\url{https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE65364}
}
\usage{
data(Hou_sim)
}
\description{
This data contains expression levels (normalized and log-transformed) for 33 cells and 100 genes.
}
\details{
This data contains raw expression levels (log-transformed but not centered) for 33 HCC cells and 100 genes. The 33 cells belongs to three different subpopulations and exhibited different biological characteristics. For descriptions of how we generated this data, please refer to the paper.
}
\examples{
data(Hou_sim)
data <- Hou_sim$x
}
\references{
Hou, Yu, et al. "Single-cell triple omics sequencing reveals genetic, epigenetic, and transcriptomic heterogeneity in hepatocellular carcinomas." Cell research 26.3 (2016): 304-319.
}
\keyword{datasets}
