% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NucleolusDerivatives.R
\name{disruptionNucleolus}
\alias{disruptionNucleolus}
\title{Compute disruption nucleolus}
\usage{
disruptionNucleolus(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
Numeric vector of length \code{n} 
representing the disruption nucleolus of the specified TU game
}
\description{
Computes the disruption nucleolus of a balanced TU game with n players.
Note that the disruption nucleolus needs to be a member of the core.
}
\examples{
library(CoopGame)
v<-c(0, 0, 0, 1, 1, 0, 1)
disruptionNucleolus(v)

\donttest{
library(CoopGame)
exampleVector<-c(0,0,0,0,2,3,4,1,3,2,8,11,6.5,9.5,14)
disruptionNucleolus(exampleVector)
#[1] 3.193548 4.754839 2.129032 3.922581
}

}
\references{
Littlechild S.C. and Vaidya K.G. (1976) "The propensity to disrupt and the disruption nucleolus of a characteristic function game", Int. Journal of Game Theory 5(2), pp. 151--161
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}

Johannes Anwander \email{anwander.johannes@gmail.com}
}
