% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DatastreamUserCreated_TimeSeries.R
\name{DSTimeSeriesRequestObject}
\alias{DSTimeSeriesRequestObject}
\title{DSTimeSeriesRequestObject}
\value{
DSTimeSeriesRequestObject object
}
\description{
This is a subclass of DSTimeSeriesUserObjectBase and is used to create or modify a timeseries.
(See DSTimeSeriesUserObjectBase for details of all the superclass properties.)
}
\section{Super classes}{
\code{\link[DatastreamR:DSUserObjectBase]{DatastreamR::DSUserObjectBase}} -> \code{\link[DatastreamR:DSTimeSeriesUserObjectBase]{DatastreamR::DSTimeSeriesUserObjectBase}} -> \code{DSTimeSeriesRequestObject}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{Id}}{A valid TimeSeries Id}

\item{\code{DataInput}}{A DSTimeSeriesDataInput object used to supply the start date, end date, frequency and
list of data values. (See DSTimeSeriesDataInput for details.)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DSTimeSeriesRequestObject-new}{\code{DSTimeSeriesRequestObject$new()}}
\item \href{#method-DSTimeSeriesRequestObject-clone}{\code{DSTimeSeriesRequestObject$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="DatastreamR" data-topic="DSUserObjectBase" data-id="SetSafeUpdateParams"><a href='../../DatastreamR/html/DSUserObjectBase.html#method-DSUserObjectBase-SetSafeUpdateParams'><code>DatastreamR::DSUserObjectBase$SetSafeUpdateParams()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DSTimeSeriesRequestObject-new"></a>}}
\if{latex}{\out{\hypertarget{method-DSTimeSeriesRequestObject-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSTimeSeriesRequestObject$new(
  id = "",
  startDate = NULL,
  endDate = NULL,
  frequency = NULL,
  values = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{A valid TimeSeries Id}

\item{\code{startDate}}{A datetime value defining the start date for the timeseries}

\item{\code{endDate}}{A datetime value defining the end date for the timeseries}

\item{\code{frequency}}{The frequency of the timeseries. DSUserObjectFrequency is defined in DSUserDataObjectBase.R}

\item{\code{values}}{list of float values}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
DSTimeSeriesRequestObject object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DSTimeSeriesRequestObject-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DSTimeSeriesRequestObject-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSTimeSeriesRequestObject$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
