% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Table_Makeham.R
\name{Table_Makeham}
\alias{Table_Makeham}
\title{Makeham's Law of Mortality Table Creator}
\usage{
Table_Makeham(x0, omega, A, B, C)
}
\arguments{
\item{x0}{A numeric type value. The initial age of the table.}

\item{omega}{A numeric type value. The final age of the table.}

\item{A}{A numeric type value. A parameter of the law.}

\item{B}{A numeric type value. A parameter of the law.}

\item{C}{A numeric type value. A parameter of the law.}
}
\value{
Returns a data.frame object containing age and death probabilities.
}
\description{
Creates a mortality table under Makeham's law.
}
\note{
The parameters are usually confined to the ranges shown below:
 0.001 < A < 0.003, 10^(-6) < B < 10(-3), 1.08 < C < 1.12.
}
\examples{
Table_Makeham(0,100,0.002,3*10^(-4),1.124)

}
\references{
Chapter 3 (p 77-78) of  Actuarial Mathematics (1997) by Bowers, Gerber, Hickman, Jones & Nesbitt.
}
\keyword{Makeham's}
\keyword{law}
\keyword{table.}
