% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibull.R
\name{Weibull}
\alias{Weibull}
\alias{expValWeibull}
\alias{varWeibull}
\alias{kthMomentWeibull}
\alias{expValLimWeibull}
\alias{expValTruncWeibull}
\alias{stopLossWeibull}
\alias{meanExcessWeibull}
\alias{VatRWeibull}
\alias{TVatRWeibull}
\title{Weibull Distribution}
\usage{
expValWeibull(shape, rate = 1/scale, scale = 1/rate)

varWeibull(shape, rate = 1/scale, scale = 1/rate)

kthMomentWeibull(k, shape, rate = 1/scale, scale = 1/rate)

expValLimWeibull(d, shape, rate = 1/scale, scale = 1/rate)

expValTruncWeibull(
  d,
  shape,
  rate = 1/scale,
  scale = 1/rate,
  less.than.d = TRUE
)

stopLossWeibull(d, shape, rate = 1/scale, scale = 1/rate)

meanExcessWeibull(d, shape, rate = 1/scale, scale = 1/rate)

VatRWeibull(kap, shape, rate = 1/scale, scale = 1/rate)

TVatRWeibull(kap, shape, rate = 1/scale, scale = 1/rate)
}
\arguments{
\item{shape}{shape parameter \eqn{\tau}{tau}, must be positive}

\item{rate}{rate parameter \eqn{\beta}{beta}, must be positive.}

\item{scale}{alternative parameterization to the rate parameter, scale = 1 / rate.}

\item{k}{kth-moment.}

\item{d}{cut-off value.}

\item{less.than.d}{logical; if \code{TRUE} (default) truncated mean for values <= d, otherwise, for values > d.}

\item{kap}{probability.}
}
\value{
Function :
  \itemize{
    \item \code{\link{expValWeibull}}  gives the expected value.
    \item \code{\link{varWeibull}}  gives the variance.
    \item \code{\link{kthMomentWeibull}}  gives the kth moment.
    \item \code{\link{expValLimWeibull}}  gives the limited mean.
    \item \code{\link{expValTruncWeibull}}  gives the truncated mean.
    \item \code{\link{stopLossWeibull}}  gives the stop-loss.
    \item \code{\link{meanExcessWeibull}}  gives the mean excess loss.
    \item \code{\link{VatRWeibull}}  gives the Value-at-Risk.
    \item \code{\link{TVatRWeibull}}  gives the Tail Value-at-Risk.
  }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Weibull distribution with shape parameter \eqn{\tau}{tau} and rate parameter
\eqn{\beta}{beta}.
}
\details{
The Weibull distribution with shape parameter \eqn{\tau}{t} and rate parameter
\eqn{\beta}{b} has density:
  \deqn{f\left(x\right) = \beta \tau \left( \beta x \right) ^{\tau -1} %
  \mathrm{e}^{-\left( \beta x\right) ^{\tau }}}{f(x) = b t (b x)^(t - 1) %
  e^{(-b x)^t}}
for \eqn{x \in \mathcal{R}^+}{x > 0}, \eqn{\beta > 0}{b > 0}, \eqn{\tau > 0}{t > 0}
}
\examples{
# With scale parameter
expValWeibull(shape = 2, scale = 5)

# With rate parameter
expValWeibull(shape = 2, rate = 0.2)

# With scale parameter
varWeibull(shape = 2, scale = 5)

# With rate parameter
varWeibull(shape = 2, rate = 0.2)

# With scale parameter
kthMomentWeibull(k = 2, shape = 2, scale = 5)

# With rate parameter
kthMomentWeibull(k = 2, shape = 2, rate = 0.2)

# With scale parameter
expValLimWeibull(d = 2, shape = 2, scale = 5)

# With rate parameter
expValLimWeibull(d = 2, shape = 2, rate = 0.2)

# With scale parameter
expValTruncWeibull(d = 2, shape = 2, scale = 5)

# With rate parameter
expValTruncWeibull(d = 2, shape = 2, rate = 0.2)

# Mean of values greater than d
expValTruncWeibull(d = 2, shape = 2, rate = 0.2, less.than.d = FALSE)

# With scale parameter
stopLossWeibull(d = 2, shape = 3, scale = 4)

# With rate parameter
stopLossWeibull(d = 2, shape = 3, rate = 0.25)

# With scale parameter
meanExcessWeibull(d = 2, shape = 3, scale = 4)

# With rate parameter
meanExcessWeibull(d = 2, shape = 3, rate = 0.25)

# With scale parameter
VatRWeibull(kap = .2, shape = 3, scale = 4)

# With rate parameter
VatRWeibull(kap = .2, shape = 3, rate = 0.25)

# With scale parameter
TVatRWeibull(kap = .2, shape = 3, scale = 4)

# With rate parameter
TVatRWeibull(kap = .2, shape = 3, rate = 0.25)

}
