% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EleChemr.R
\name{CV}
\alias{CV}
\title{Cyclic voltammetry digitial simulation}
\usage{
CV(
  Co = 0.001,
  Dx = 1e-05,
  Eo = 0,
  Dm = 0.45,
  Vi = 0.3,
  Vf = -0.3,
  Vs = 0.001,
  ko = 0.01,
  alpha = 0.5,
  Temp = 298.15,
  n = 1,
  Area = 1,
  l = 100,
  DerApprox = 2,
  errCheck = FALSE,
  Method = "Euler"
)
}
\arguments{
\item{Co}{bulk concentration expressed in Molar}

\item{Dx}{diffusion coefficient expressed in cm^2/s}

\item{Eo}{reduction potential of the species expressed in Volts}

\item{Dm}{simulation parameter, maximum 0.5 for explicit methods}

\item{Vi}{initial potential of the sweep expressed in Volts}

\item{Vf}{final potential of the sweepexpressed in Volts}

\item{Vs}{potential scan rate of the simulation expressed in V/s}

\item{ko}{heterogeneous electron transfer rate constant expressed in m/s}

\item{alpha}{charge transfer coefficient}

\item{Temp}{temperature in kelvin}

\item{n}{number of electrons involved in the process}

\item{Area}{area of the electrode expressed in cm^2}

\item{l}{number of time steps of the simulation}

\item{DerApprox}{number of point for the approximation of the first derivative}

\item{errCheck}{if true the function returns a list with parameters for CottrCheck function}

\item{Method}{method to be used for the simulation = "Euler" "BI" "RK4" "CN" "BDF"}
}
\value{
if errCheck == F a graph I vs E, if errCheck == T a list
}
\description{
Return a graph I vs E of the electrochemical process
}
\examples{
CV(Co = 0.001, DerApprox = 2, Dm = 0.45, errCheck = FALSE, Method = "Euler")

}
