#' @title All sRNA sequences in F1 (F1: the polyploid progeny).
#'
#' @docType data
#' @name F1_sRNA_seq
NULL

#' @title All sRNA sequences in P1 (P1: one of the parents).
#'
#' @docType data
#' @name P1_sRNA_seq
NULL

#' @title All sRNA sequences in P2 (P2: one of the parents).
#'
#' @docType data
#' @name P2_sRNA_seq
NULL

#' @title Count table of miRNAs in P2 (P2: one of the parents).
#'
#' @docType data
#' @name P2_miRNA_count
#' @description Count table of miRNAs in P2 species. The "P2" represents one of parents.
#' @examples
#' head(P2_miRNA_count)
#' #                sequence  Bnapus.1  Bnapus.2  Bnapus.3
#' #1  TTTGGATTGAAGGGAGCTCTA     29848     12094     10685
#' #2  TTAGATTCACGCACAAACTCG       986       571       456
#' #3  TGAAGCTGCCAGCATGATCTA      3152      1436      1091
#' #4 CTTTGTCTATCGTTTGGAAAAG      2449      1307      1116
#' #5  GATCATGTTCGCAGTTTCACC      1364       650       656
#' #6  TTTCCAAATGTAGACAAAGCA     11658      3914      4123
NULL

#' @title RPM table of miRNAs in P2 (P2: one of the parents).
#'
#' @docType data
#' @name P2_miRNA_rpm
#' @description RPM table of miRNAs in P2 species. The "P2" represents one of parents.
#' @examples
#' head(P2_miRNA_rpm)
#' #                sequence   Bnapus.1   Bnapus.2   Bnapus.3
#' #1  TTTGGATTGAAGGGAGCTCTA    1804.35    1362.88    1439.22
#' #2  TTAGATTCACGCACAAACTCG      59.60      64.35      61.42
#' #3  TGAAGCTGCCAGCATGATCTA     190.54     161.82     146.95
#' #4 CTTTGTCTATCGTTTGGAAAAG     148.04     147.29     150.32
#' #5  GATCATGTTCGCAGTTTCACC      82.46      73.25      88.36
#' #6  TTTCCAAATGTAGACAAAGCA     704.74     441.07     555.35
NULL

#' @title Count table of miRNAs in P1 (P1: one of the parents).
#'
#' @docType data
#' @name P1_miRNA_count
#' @description Count table of miRNAs in P1 species. The "P1" represents one of parents.
#' @examples
#' head(P1_miRNA_count)
#' #                sequence   Bnapus.1   Bnapus.2   Bnapus.3
#' #1  TTTGGATTGAAGGGAGCTCTA      29848      12094      10685
#' #2  TTAGATTCACGCACAAACTCG        986        571        456
#' #3  TGAAGCTGCCAGCATGATCTA       3152       1436       1091
#' #4 CTTTGTCTATCGTTTGGAAAAG       2449       1307       1116
#' #5  GATCATGTTCGCAGTTTCACC       1364        650        656
#' #6  TTTCCAAATGTAGACAAAGCA      11658       3914       4123
NULL

#' @title RPM table of miRNAs in P1 (P1: one of the parents).
#'
#' @docType data
#' @name P1_miRNA_rpm
#' @description RPM table of miRNAs in P1 species. The "P1" represents one of parents.
#' @examples
#' head(P1_miRNA_rpm)
#' #               sequence    Brapa.1    Brapa.2    Brapa.3
#' #1 TTTGGATTGAAGGGAGCTCTA    1641.18    1116.03    1014.37
#' #2 TGAAGCTGCCAGCATGATCTA     129.33     103.23     103.68
#' #3 TTTCCAAATGTAGACAAAGCA     905.23     920.57    1180.51
#' #4 TCGGACCAGGCTTCATCCCCC      24.71      14.38      15.03
#' #5 AGAATCTTGATGATGCTGCAG      48.64      41.09      41.60
#' #6 TTGACAGAAGAAAGAGAGCAC      86.96      81.23      67.41
NULL

#' @title Count table of miRNAs in F1 (F1: the polyploid progeny).
#'
#' @docType data
#' @name F1_miRNA_count
#' @description Count table of miRNAs in F1 species. The "F1" represents the polyploid progeny.
#' @examples
#' head(F1_miRNA_count)
#' #                sequence     BF1.1    BF1.2    BF1.3
#' #1  TTTGGATTGAAGGGAGCTCTA     20233     6388    16732
#' #2  TTTCCAAATGTAGACAAAGCA     19909     5157    16076
#' #3    TCCCAAATGTAGACAAAGC        82       33      103
#' #4 CTTTGTCTATCGTTTGGAAAAG      2367     1040     3203
#' #5  TTGGACTGAAGGGAGCTCCTT        34        9       21
#' #6  TCGGACCAGGCTTCATTCCCC      3281      607     1289
NULL

#' @title RPM table of miRNAs in F1 (F1: the polyploid progeny).
#'
#' @docType data
#' @name F1_miRNA_rpm
#' @description RPM table of miRNAs in F1 species. The "F1" represents the polyploid progeny.
#' @examples
#' head(F1_miRNA_rpm)
#' #                sequence     BF1.1    BF1.2     BF1.3
#' #1  TTTGGATTGAAGGGAGCTCTA   1512.16  1086.35   2032.97
#' #2  TTTCCAAATGTAGACAAAGCA   1487.94   877.01   1953.27
#' #3    TCCCAAATGTAGACAAAGC      6.13     5.61     12.51
#' #4 CTTTGTCTATCGTTTGGAAAAG    176.90   176.86    389.17
#' #5  TTGGACTGAAGGGAGCTCCTT      2.54     1.53      2.55
#' #6  TCGGACCAGGCTTCATTCCCC    245.21   103.23    156.62
NULL
