% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hake.R
\docType{data}
\name{Hake}
\alias{Hake}
\title{Stock and recruitment data for Hake, 1982-1996.}
\format{
A data frame with 15 observations on the following 3 variables.
 \describe{ 
   \item{year}{a numeric vector of years 1982-1996}
   \item{recruits}{a numeric vector of the number of recruits in millions} 
   \item{spawn.biomass}{a numeric vector of spawning biomass in thousand tonnes} 
 }
}
\source{
Cadima, E. 2003. Fish Stock Assessment Manual, FAO Fisheries Department. 131 pp. \href{https://raw.githubusercontent.com/fishR-Core-Team/FSAdata/main/data-raw/Hake.csv}{CSV file}
}
\description{
Stock and recruitment data for Hake (\emph{Merluccius merluccius}), 1982-1996.
}
\section{Topic(s)}{

 \itemize{
   \item Stock-Recruit
   \item Recruitment
 }
}

\examples{
data(Hake)
str(Hake)
head(Hake)
op <- par(mfrow=c(1,2),pch=19)
plot(recruits~year,data=Hake,type="l")
plot(recruits~spawn.biomass,data=Hake)
par(op)

}
\concept{Recruitment}
\concept{Stock-Recruit}
\keyword{datasets}
